import { number } from '@amcharts/amcharts4/core'
import { padStart } from 'lodash'

/**
 * 补足数字位数
 * @param digit 数字
 * @param len 位数
 */
export const fillDigit = (digit: number, len: number) => {
  return padStart('' + digit, len, '0')
}

/**
 * 判断设备
 */
export const isPC = () => {
  return !navigator.userAgent.match(/(iPhone|iPod|iPad|Android|Mobile|BlackBerry|Symbian|Windows Phone)/i)
}

export const query = (url?:string)=>{
  url = url??location.href
  let str = url.substr(url.indexOf('?') + 1)
  const arr = str.split('&')
  let json = {} as any
  for(let i = 0; i < arr.length; i++) {
    let item = arr[i].split('=')
    json[item[0]] = item[1]
  }

  if(url.indexOf(process.env.VUE_APP_SHARE_URL)!=-1&&!json.ViewSlideshow){
    json = {
      SalesTripId: str.slice(2)
    } as any
    return json
  }else return json
}

/**
 * 提取字符串中的文字
 */
export const getHtmlPlainText = (html_str:string) => {
  let re = new RegExp('<[^<>]+>', 'g')
  if (html_str) {
    let text = html_str.replace(re, '')
    return text
  } else {
    return ''
  }
}

// 计算距离当前多少天
export const getDaysBetween = (date1:any, date2:any) => {
  const ONE_DAY = 1000 * 60 * 60 * 24; // 一天的毫秒数
  const date1Time = date1.getTime(); // 获取时间戳
  const date2Time = date2.getTime();

  const difference = Math.abs(date1Time - date2Time); // 获取时间差
  return Math.round(difference / ONE_DAY); // 两个日期之间的天数
}

export const formatDateTimeToRead = (dateStr:string,prefix:string='') =>{
  let minute = 1000 * 60;
  let hour = minute * 60;
  let day = hour * 24;
  let halfamonth = day * 15;
  let month = day * 30;
  let dateTimeStamp = Date.parse(dateStr.replaceAll('-',"/"))
  let result = ''
  let now = new Date().getTime();
  let diffValue = now - dateTimeStamp;
  if(diffValue < 0){
  //若日期不符则弹出窗口告之
  //alert("结束日期不能小于开始日期！");
    return ''
  }
  let monthC =diffValue/month;
  let weekC =diffValue/(7*day);
  let dayC =diffValue/day;
  let hourC =diffValue/hour;
  let minC =diffValue/minute;
  if(monthC>=1 && monthC<=12){
    result=parseInt(monthC.toString()) + "月前";
  }
  else if(monthC>12){
    result=dateStr
  }
  else if(weekC>=1){
    result=parseInt(weekC.toString()) + "周前";
  }
  else if(dayC>=1){
    result=parseInt(dayC.toString()) +"天前";
  }
  else if(hourC>=1){
    result=parseInt(hourC.toString()) +"小时前";
  }
  else if(minC>=1){
    result=parseInt(minC.toString()) +"分钟前";
  }else
    result= "刚刚";
  return prefix+result;
}