import { fa } from 'element-plus/es/locale'
import { defineStore } from 'pinia'

export interface ScreenState {
  screening: boolean,
  market:boolean,
  model:number,
  isModel: boolean,
  ConfigId:number,
  TemplateType: [],
  TemplateDataSource: [],
  TempId: number,
  CoverImg: any,
  isCoverImg: boolean,
  dataLoading: number,
  SourceLoading: boolean,
  imgPoolVisible: boolean,
  imgReplaceVisible: boolean,
}

export const useScreenStore = defineStore('screen', {
  state: (): ScreenState => ({
    screening: false, // 是否进入放映状态
    market: true,
    model: 0, // 是否有新增修改模版权限
    isModel: false, // 该团是否存在模版
    ConfigId: 0,
    TemplateType: [], // 数据源分类
    TemplateDataSource: [], // 所有数据源
    TempId: 0, // 模版Id
    CoverImg: null, // 封面图
    isCoverImg: false, // 封面
    dataLoading: 0, // 记录保存是否成功
    SourceLoading: false, // 记录数据源是否更改
    imgPoolVisible: false,//新增上传图片弹窗
    imgReplaceVisible: false,//替换图片弹窗
  }),

  actions: {
    setScreening(screening: boolean) {
      if(location.href.indexOf(process.env.VUE_APP_SHARE_URL)!=-1&&!screening) return
      this.screening = screening
      if (screening) {
        this.market = false
      }
    },
    setMarket(market: boolean) {
      this.market = market
    },
    setModel(model: number) {
      this.model = model
    },
    setIsModel(isModel: boolean) {
      this.isModel = isModel
    },
    setConfigId(ConfigId: number) {
      this.ConfigId = ConfigId
    },
    setTemplateType(TemplateType: []) {
      this.TemplateType = TemplateType
    },
    setCoverImg(CoverImg: any) {
      this.CoverImg = CoverImg
    },
    setIsCoverImg(isCoverImg: boolean) {
      this.isCoverImg = isCoverImg
    },
    setTemplateDataSource(TemplateDataSource: []) {
      this.TemplateDataSource = TemplateDataSource
    },
    setTempId(TempId: number) {
      this.TempId = TempId
    },
    setDataLoading(dataLoading: number) {
      this.dataLoading = dataLoading
    },
    setSourceLoading(SourceLoading: boolean) {
      this.SourceLoading = SourceLoading
    },
    setImgPoolVisible(imgPoolVisible: boolean) {
      this.imgPoolVisible = imgPoolVisible
    },
    setImgReplaceVisible(imgReplaceVisible: boolean) {
      this.imgReplaceVisible = imgReplaceVisible
    }
  },
})