export type CustomerRate = 'FREE'|'VIP'|'EN'
export interface CustomerTheme{
    name:CustomerRate,
    bg:string,
    color:string,
    desc:string
}

export const FREE_USER_THEME:CustomerTheme = {name:'FREE',bg:'linear-gradient(270deg, #94A3C0 0%, #99A3B8 100%)',color:'#94a3c0', desc:'免费版·个人'}
export const VIP_USER_THEME:CustomerTheme = {name:'VIP',bg:'linear-gradient(270deg, #4165E2 0%, #5276F5 100%)',color:'#dd9b38', desc:'会员版·个人'}
export const ENT_USER_THEME:CustomerTheme = {name:'EN',bg:'linear-gradient(270deg, #DD9B38 0%, #E6B351 100%);',color:'#252860', desc:'会员版·企业'}

export const CustomerThemeConfig:CustomerTheme[] = [FREE_USER_THEME,VIP_USER_THEME,ENT_USER_THEME] 