
class FileService{
    static getImageSizeWithoutDownloading = async (url: string): Promise<{ width: number; height: number }> => {
        const response = await fetch(url, { method: 'HEAD' }); // Use HEAD request to get metadata
        const contentLength = response.headers.get('Content-Length');
      
        if (!contentLength) {
          throw new Error('Unable to determine Content-Length');
        }
      
        const rangeEnd = Math.min(parseInt(contentLength, 10), 1024); // Read the first 1KB of data
        const partialResponse = await fetch(url, {
          headers: {
            Range: `bytes=0-${rangeEnd}`,
          },
        });
      
        const blob = await partialResponse.blob();
        const objectURL = URL.createObjectURL(blob);
        const image = new Image();
      
        return new Promise((resolve, reject) => {
          image.onload = () => {
            resolve({ width: image.width, height: image.height });
            URL.revokeObjectURL(objectURL);
          };
      
          image.onerror = reject;
      
          image.src = objectURL;
        });
    }
}

export default FileService