import { RouteRecordRaw } from 'vue-router'


const routes: RouteRecordRaw[] = [
  {
    path: '/',
    component: () => import('@/views/Website/index.vue'),
    meta:{
      title:'Travel Design 一个面向旅游行程设计的创作平台'
    }
  },
  {
    path: '/space',
    component: () => import('@/views/Index.vue'),
    meta:{
      title:'个人空间'
    },
    children:[
      {
        path: '/space',
        component: () => import('@/views/SellTemplate/Workspace.vue'),
        meta:{
          title:'个人空间'
        }
      },
      {
        path: '/space/:current(\\d+)?',
        component: () => import('@/views/SellTemplate/Workspace.vue'),
        meta:{
          title:'个人空间'
        }
      },
      {
        path: '/space/cp',
        component: () => import('@/views/Company/Product.vue'),
        meta:{
          title:'升级到企业版本'
        }
      }
    ]
  },
  {
    path: '/login',
    component: () => import('@/views/Auth/Login.vue'),
    meta:{
      title:'登录 Travel Design'
    }
  },
  {
    path: '/regist',
    component: () => import('@/views/Auth/Regist.vue'),
    meta:{
      title:'注册 Travel Design'
    }
  },
  {
    path: '/notfound',
    component: () => import('@/views/ErrorNotFound.vue'),
    meta:{
      title:'Oops! 出错了'
    }
  },
  {
    path: '/autoLogin',
    component: () => import('@/views/Auth/AutoLogin.vue'),
    meta:{
      title:'自动登录中...'
    }
  },
  {
    path: '/market',
    component: () => import('@/views/Market/Index.vue'),
    meta:{
      title:'模板管理'
    }
  },
  {
    path: '/market/create',
    component: () => import('@/views/Market/Index.vue'),
    meta:{
      title:'选择模板进行创作'
    }
  },
  {
    path: '/market/create/ad',
    component: () => import('@/views/Market/Index.vue'),
    meta:{
      title:'选择广告模板'
    }
  },
  {
    path: '/market/create/trip',
    component: () => import('@/views/Market/Index.vue'),
    meta:{
      title:'选择行程模板'
    }
  },
  {
    path: '/market/op/:configId(\\d+)/:temptype(\\d+)?',
    component: () => import('@/views/Market/Index.vue'),
    meta:{
      title:'选择模板进行创作'
    }
  },
  {
    path: '/editor/:id(\\d+)/:tid(\\d+)/:type(\\d+)/:pid(\\d+)/e/:e(\\d+)/c/:c(\\d+)',
    component: () => import('@/views/Editor/Editor.vue'),
    meta:{
      title:'编辑'
    }
  },
  {
    path: '/editor/:tid(\\d+)/:type(\\d+)',
    component: () => import('@/views/Editor/Editor.vue'),
    meta:{
      title:'新建'
    }
  },
  {
    path: '/team_editor/:configId(\\d+)/:tid(\\d+)',
    component: () => import('@/views/Editor/Editor.vue'),
    meta:{
      title:'设计团队行程'
    }
  },
  {
    path: '/team_editor/:configId(\\d+)',
    component: () => import('@/views/Editor/Editor.vue'),
    meta:{
      title:'修改团队行程'
    }
  },
  {
    path: '/manager_template/:tid(\\d+)/:type(\\d+)',
    component: () => import('@/views/Editor/Editor.vue'),
    meta:{
      title:'新建'
    }
  },
  {
    path: '/create_template/:type(\\d+)',
    component: () => import('@/views/Editor/Editor.vue'),
    meta:{
      title:'新建'
    }
  },
  {
    path: '/team_preview/:configId(\\d+)/:w(\\d+)?',
    component: () => import('@/views/Editor/Preview.vue'),
    meta:{
      title:'行程生成预览'
    }
  },
  {
    path: '/preview/:tid(\\d+)',
    component: () => import('@/views/Preview/PreviewCustomSlider.vue'),
    meta:{
      title:'行程生成预览'
    }
  },
  {
    path: '/play/:id(\\d+)/:logId(\\d+)/:status(\\d+)',
    component: () => import('@/views/Editor/PlayView.vue'),
    meta:{
      title:'行程生成预览'
    }
  },
  {
    path: '/:catchAll(.*)*',
    component: () => import('@/views/ErrorNotFound.vue'),
    meta:{
      title:'Oops! 出错了'
    }
  }
];

export default routes;