
import {compressionThumbnail} from '@/utils/psdParser/compressor'

class FileService{
    static getImageSizeWithoutDownloading = async (url: string): Promise<{ width: number; height: number }> => {
        const response = await fetch(url, { method: 'HEAD' }); // Use HEAD request to get metadata
        const contentLength = response.headers.get('Content-Length');
      
        if (!contentLength) {
          throw new Error('Unable to determine Content-Length');
        }
      
        const rangeEnd = Math.min(parseInt(contentLength, 10), 1024); // Read the first 1KB of data
        const partialResponse = await fetch(url, {
          headers: {
            Range: `bytes=0-${rangeEnd}`,
          },
        });
      
        const blob = await partialResponse.blob();
        const objectURL = URL.createObjectURL(blob);
        const image = new Image();
      
        return new Promise((resolve, reject) => {
          image.onload = () => {
            resolve({ width: image.width, height: image.height });
            URL.revokeObjectURL(objectURL);
          };
      
          image.onerror = reject;
      
          image.src = objectURL;
        });
    }

    static convertNetworkToBase64Async = async (url:string): Promise<{ width: number; height: number,url:string }> =>{
      let result:{ width: number; height: number,url:string }={
        width:0,
        height:0,
        url:''
      }
      const response = await fetch(url)
      const blob = await response.blob()
      const objectURL = URL.createObjectURL(blob);
      const image = new Image();
      return new Promise(async (resolve, reject) => {

        image.onload = () => {
          result.width=image.width
          result.height=image.height
          const reader = new FileReader();
          reader.onload = async (e) => {
            result.url = reader.result as string
            result.url = await compressionThumbnail(result.url,"image/jpeg", 0, 0.9)
            resolve(result)
          }
          reader.readAsDataURL(blob);
        };
        image.onerror = reject;
      
        image.src = objectURL;
      })
    }
}

export default FileService