import Api,{ HttpResponse, Result } from './../utils/request';

/**
 * 配置相关方法
 */
class ConfigService{
     
    /**
     * 分享销售模版详情
     */
     static async GetTripOtherByCode(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripOtherByCode",params)
    }

    /**
     * 销售模版详情
     */
     static async sellGetTemplateDetails(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripOther",params)
    }

    /**
     * 销售删除模版
     */
     static async sellSetRemoveTemplate(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_RemoveTripOther",params)
    }

    /**
     * 销售新增编辑模版
     */
     static async sellSetTemplate(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_SetTripOther",params)
    }

    /**
     * 获取销售模版列表
     */
     static async sellGetTripOtherPage(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripOtherPage",params)
    }

    
    /**
     * 关键词检索获取行程酒店 餐 景点
     */
     static async getSourceDatas(params : any):Promise<HttpResponse>{
        return Api.Post("hotel_post_GetSourceList",params)
    }

    /**
     * 根据ConfigId获取行程配置相关数据
     */
     static async triptemplateGetTripFiledData(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripFiledData",params)
    }

    /**
     * 根据团期配置编号获取行程详情
     */
     static async triptemplateGetTripConfig(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripConfig",params)
    }

    /**
     * 新增修改模版数据
     */
     static async SetTripConfig(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_SetTripConfig",params)
    }

    /**
     * 删除模版
     */
     static async SetDeleteTripTemplate(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_RemoveTripTemplate",params)
    }

    /**
     * 新增修改模版
     */
     static async SetTripTemplateSlide(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_SetTripTemplate",params)
    }

    /**
     * 根据TempId获取模版数据
     */
     static async GetTripTemplateSlide(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripTemplate",params)
    }

    /**
     * 获取绑定数据源列表
     */
     static async TemplateGetTripFiled(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripFiled",params)
    }

    /**
     * 
     * @returns 获取模板查询条件
     */
    static async GetTemplateQueryAsync():Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTemplateConfigData",{})
    }

    /**
     * 获取模板市场分页列表
     */
    static async GetTemplagePageAsync(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripTemplatePage",params)
    }

    /**
     * 图片素材分页列表
     */
     static async GetPicList(params : any):Promise<HttpResponse>{
        return Api.Post("hotel_post_GetPicList",params)
    }

    /**
     * 新增颜色
     */
     static async SetTemplateConfigData(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_SetTemplateConfigData",params)
    }
}
export default ConfigService;