import { useMapStore } from '@/store'
import { MapTheme } from "@/types/mapTheme"
import { ref } from "vue"

export default() => {

    const map = useMapStore()

    const whiteLight:MapTheme={
        fillColor:['#FFFFFF'],
        mapBackground:'#CDE8FF',
        line:{
            color:'#949494',
            width:2,
            type:2
        },
        text:{
            color:'#131313',
            size:24,
            fontFamily:'pingfangr'
        },
        tag:{
            size:0.75,
            color:'#050505',
            border:6,
            borderColor:'#FFFFFF'
        },
        border:1,
        borderColor:'#F1F1F1'
    }

    const whiteRed:MapTheme={
        fillColor:['#FFFFFF'],
        mapBackground:'#E5E5E5',
        line:{
            color:'#707070',
            width:2,
            type:2
        },
        text:{
            color:'#000000',
            size:22,
            fontFamily:'DengXian-Bold'
        },
        tag:{
            size:0.5,
            color:'#991B04',
            border:5,
            borderColor:'#FFFFFF'
        },
        border:1,
        borderColor:'#F1F1F1'
    }

    const coffer:MapTheme={
        fillColor:['#543E2C'],
        mapBackground:'#423323',
        line:{
            color:'#707070',
            width:2,
            type:2
        },
        text:{
            color:'#FFFBEF',
            size:24,
            fontFamily:'SourceHanSansCN-Regular'
        },
        tag:{
            size:0.5,
            color:'#3C2919',
            border:5,
            borderColor:'#543E2C'
        },
        border:1,
        borderColor:'#5F4734'
    }

    const black:MapTheme={
        fillColor:['#212121'],
        mapBackground:'#FFFFFF',
        line:{
            color:'#B09B80',
            width:2,
            type:2
        },
        text:{
            color:'#FFFFFF',
            size:20,
            fontFamily:'SourceHanSansCN-Light'
        },
        tag:{
            size:0.6,
            color:'#B09B80',
            border:4,
            borderColor:'#212121'
        },
        border:1,
        borderColor:'#353535'
    }

    const blue:MapTheme={
        fillColor:['#1953C1'],
        mapBackground:'#DAE2ED',
        line:{
            color:'#000000',
            width:1,
            type:2
        },
        text:{
            color:'#04101C',
            size:20,
            fontFamily:'SourceHanSansCN-Medium'
        },
        tag:{
            size:0.4,
            color:'#04101C',
            border:2,
            borderColor:'#1953C1'
        },
        border:4,
        borderColor:'#DAE2ED'
    }

    const zangQingStyle:MapTheme={
        fillColor:['#182832'],
        mapBackground:'#283B47',
        line:{
            color:'#F5F8F5',
            width:2,
            type:2
        },
        text:{
            color:'#F5F8F5',
            size:20,
            fontFamily:'SourceHanSansCN-Regular'
        },
        tag:{
            size:0.5,
            color:'#F5F8F5',
            border:10,
            borderColor:'#182832'
        },
        border:1,
        borderColor:'#233642'
    }

    const redMoreStyle:MapTheme={
        fillColor:['#E5899B','#ECC195','#CDDCA2','#F99268'],
        mapBackground:'#FFFFFF',
        line:{
            color:'#000000',
            width:1,
            type:2
        },
        text:{
            color:'#000000',
            size:18,
            fontFamily:'SourceHanSansCN-Regular'
        },
        tag:{
            size:0.4,
            color:'#04101C',
            border:0,
            borderColor:'#FFFFFF'
        },
        border:6,
        borderColor:'#FFFFFF'
    }

    const huoli:MapTheme={
        fillColor:['#6FAACE','#B0D8DE','#66C097','#9ECD74'],
        mapBackground:'#FFFFFF',
        line:{
            color:'#000000',
            width:1,
            type:2
        },
        text:{
            color:'#04101C',
            size:18,
            fontFamily:'SourceHanSansCN-Regular'
        },
        tag:{
            size:0.4,
            color:'#04101C',
            border:2,
            borderColor:'#1953C1'
        },
        border:4,
        borderColor:'#FFFFFF'
    }

    const yellow:MapTheme={
        fillColor:['#0000001a'],
        mapBackground:'#EDF261',
        line:{
            color:'#000000',
            width:2,
            type:2
        },
        text:{
            color:'#000000',
            size:26,
            fontFamily:'microsoft yahei ui light'
        },
        tag:{
            size:1,
            color:'#000000',
            border:10,
            borderColor:'#D5D957'
        },
        border:1,
        borderColor:'#C9CD52'
    }

    const red:MapTheme={
        fillColor:['#00000033'],
        mapBackground:'#8D2505',
        line:{
            color:'#FFFFFF',
            width:2,
            type:2
        },
        text:{
            color:'#FFFFFF',
            size:26,
            fontFamily:'microsoft yahei ui light'
        },
        tag:{
            size:1,
            color:'#FFFFFF',
            border:10,
            borderColor:'#00000033'
        },
        border:1,
        borderColor:'#0000001a'
    }

    const green:MapTheme={
        fillColor:['#FFFFFF33'],
        mapBackground:'#146F2E',
        line:{
            color:'#FFFFFF',
            width:2,
            type:2
        },
        text:{
            color:'#FFFFFF',
            size:26,
            fontFamily:'microsoft yahei ui light'
        },
        tag:{
            size:1,
            color:'#FFFFFF',
            border:10,
            borderColor:'#438C58'
        },
        border:1,
        borderColor:'#619D72'
    }

    const themes = ref<{label:string,url:string,style?:MapTheme}[]>([
        {
            label:"浅白色",
            url:"https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Goods/1710396691000_106.png",
            style:whiteLight
        },
        {
            label:"浅白红",
            url:"https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Goods/1710396691000_340.png",
            style:whiteRed
        },
        {
            label:"深咖",
            url:"https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Goods/1710396691000_705.png",
            style:coffer
        },
        {
            label:"藏青",
            url:"https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Goods/1710396691000_334.png",
            style:zangQingStyle
        },
        {
            label:"黑金",
            url:"https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Goods/1710396691000_30.png",
            style:black
        },
        {
            label:"克莱姆因蓝",
            url:"https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Goods/1710396691000_810.png",
            style:blue
        },
        {
            label:"活力混搭",
            url:"https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Goods/1710396691000_769.png",
            style:huoli
        },
        {
            label:"热力混搭",
            url:"https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Goods/1710396691000_893.png",
            style:redMoreStyle
        },
        {
            label:"生机绿",
            url:"https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Goods/1710496081000_990.png",
            style:green
        },
        {
            label:"魅力红",
            url:"https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Goods/1710496081000_274.png",
            style:red
        },
        {
            label:"柠檬黄",
            url:"https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Goods/1710496081000_326.png",
            style:yellow
        }
    ])

    const setTheme = (theme:MapTheme|null)=>{
        map.setCurrentTheme(theme)
    }

    return {
        themes,
        setTheme
    }
}