import Api,{ HttpResponse, Result } from './../utils/request';


class UserServices{

    static async AutoLoginAsync(userId:number):Promise<HttpResponse>{
        let msg = {EmployeeId:userId}
        return Api.Post("admin_get_GetErpLoginInfoByUid",msg)
    }

    static async PasswordLoginAsync(account:string,pwd:string,tid:string=''):Promise<HttpResponse>{
        let msg = {account,pwd,tid}
        return Api.Post("travel_login_password",msg)
    }

    static async RegistUserByPassAsync(account:string,pwd:string,nickname:string,token:string,tid:string=''):Promise<HttpResponse>{
        let msg:any = {account,pwd,nickname,"v_token":token}
        if(tid!='') msg.tid = tid
        return Api.Post("travel_user_regist_pwd",msg)
    }

    static async GetProductAsync():Promise<HttpResponse>{
        let msg = {pageIndex:1,pageSize:100}
        return Api.Post("ppt_GetPPTProduct",msg)
    }
    //
    static async SetMemberInfoAsync(nk:string,id:string,ia:0|1|-1):Promise<HttpResponse>{
        let msg = {nk,id,ia}
        return Api.Post("travel_set_member_info",msg)
    }

    static async RemoveMemberAsync(id:string):Promise<HttpResponse>{
        let msg = {id}
        return Api.Post("travel_remove_member",msg)
    }
}
export default UserServices;