import { padStart } from 'lodash'

/**
 * 补足数字位数
 * @param digit 数字
 * @param len 位数
 */
export const fillDigit = (digit: number, len: number) => {
  return padStart('' + digit, len, '0')
}

export const openNewBlank = (path:string) => {
  if(path!=''){
    const url = `${window.location.origin}${path}`
    window.open(url, '_blank')
  }
}
export const openCustomerService = ()=>{
  const url = 'https://work.weixin.qq.com/kfid/kfc378aada578ca8b0e'
  window.open(url, '_blank')
}
export const createSaleEditorLink = (id:number,tid:number,type:1|2,pid:number,ep:0|1,cp:0|1) =>{
  return `/editor/${id}/${tid}/${type}/${pid}/e/${ep}/c/${cp}`
}
export const createSaleCreateLink = (tid:number,type:1|2) =>{
  return `/editor/${tid}/${type}`
}
export const createOpEditorLink = (configId:number,tid:number) =>{
  return `/team_editor/${configId}/${tid}`
}
export const managerTemplateLink = (tid:number,type:1|2) =>{
  return `/manager_template/${tid}/${type}`
}
export const createPlayLink = (id:number,loginId:number,status:1|2) =>{
  return `/play/${id}/${loginId}/${status}`
}
/**
 * 判断设备
 */
export const isPC = () => {
  return !navigator.userAgent.match(/(iPhone|iPod|iPad|Android|Mobile|BlackBerry|Symbian|Windows Phone)/i)
}

export const query = (url?:string)=>{
  url = url??location.href
  let str = url.substr(url.indexOf('?') + 1)
  const arr = str.split('&')
  let json = {} as any
  for(let i = 0; i < arr.length; i++) {
    let item = arr[i].split('=')
    json[item[0]] = item[1]
  }

  if(url.indexOf(process.env.VUE_APP_SHARE_URL)!=-1&&!json.ViewSlideshow){
    json = {
      SalesTripId: str.slice(2)
    } as any
    return json
  }else return json
}

/**
 * 提取字符串中的文字
 */
export const getHtmlPlainText = (html_str:string) => {
  let re = new RegExp('<[^<>]+>', 'g')
  if (html_str) {
    let text = html_str.replace(re, '')
    return text
  } else {
    return ''
  }
}

// 计算距离当前多少天
export const getDaysBetween = (date1:any, date2:any) => {
  const ONE_DAY = 1000 * 60 * 60 * 24; // 一天的毫秒数
  const date1Time = date1.getTime(); // 获取时间戳
  const date2Time = date2.getTime();

  const difference = Math.abs(date1Time - date2Time); // 获取时间差
  return Math.round(difference / ONE_DAY); // 两个日期之间的天数
}

export const formatDateTimeToRead = (dateStr:string,prefix:string='') =>{
  let minute = 1000 * 60;
  let hour = minute * 60;
  let day = hour * 24;
  let halfamonth = day * 15;
  let month = day * 30;
  let dateTimeStamp = Date.parse(dateStr.replaceAll('-',"/"))
  let result = ''
  let now = new Date().getTime();
  let diffValue = now - dateTimeStamp;
  if(diffValue < 0){
  //若日期不符则弹出窗口告之
  //alert("结束日期不能小于开始日期！");
    return ''
  }
  let monthC =diffValue/month;
  let weekC =diffValue/(7*day);
  let dayC =diffValue/day;
  let hourC =diffValue/hour;
  let minC =diffValue/minute;
  if(monthC>=1 && monthC<=12){
    result=parseInt(monthC.toString()) + "月前";
  }
  else if(monthC>12){
    result=dateStr
  }
  else if(weekC>=1){
    result=parseInt(weekC.toString()) + "周前";
  }
  else if(dayC>=1){
    result=parseInt(dayC.toString()) +"天前";
  }
  else if(hourC>=1){
    result=parseInt(hourC.toString()) +"小时前";
  }
  else if(minC>=1){
    result=parseInt(minC.toString()) +"分钟前";
  }else
    result= "刚刚";
  return prefix+result;
}

// 暂无数据img
export const noDataImg = (type:Number) =>{
  if(type==1) return require('@/assets/img/noData.png')
  if(type==2) return require('@/assets/img/theEend.png')
}

// 主色值
export const DominantColour = () =>{
  return [
    {ColorName:'红',ColorValue:'#E43939',Id:1},
    {ColorName:'橙',ColorValue:'#F79A2C',Id:2},
    {ColorName:'黄',ColorValue:'#FFF60B',Id:3},
    {ColorName:'绿',ColorValue:'#3DD948',Id:4},
    {ColorName:'青',ColorValue:'#39CAE4',Id:5},
    {ColorName:'蓝',ColorValue:'#2C31F1',Id:6},
    {ColorName:'紫',ColorValue:'#7A39E4',Id:7},
    {ColorName:'玫红',ColorValue:'#E65FC1',Id:8},
    {ColorName:'棕色',ColorValue:'#D0B478',Id:9},
    {ColorName:'白',ColorValue:'#FFFFFF',Id:10},
    {ColorName:'黑',ColorValue:'#000000',Id:11},
    {ColorName:'灰',ColorValue:'#BABABA',Id:12},
  ]
}