import { defineStore } from "pinia"
import { useUserStore } from "./user"

export interface Menu{
    name:string,
    icon:string,
    url:string,
    children?:Menu[]
}
export type MenuOwner = '*'|'F'|'V'|'A'|'E'|'M'
export interface MenuState {
    // freeUser: Menu[],
    // vipUser: Menu[],
    // enterpriseUser: Menu[],
    // enterpriseAdmin: Menu[]
    userMenu:Menu[]
    currentMenu: Menu|null
}

const menus:{menu:Menu,owner:MenuOwner}[] = [
    {menu:{name:'账号一览',icon:'IconEarth',url:'/u'},owner:'*'},
    {menu:{name:'订单/发票',icon:'IconCurrency',url:'/u/order'},owner:'*'},
    {menu:{name:'账户设置',icon:'IconProtect',url:'/u/setting'},owner:'*'}
]

export const useMenuStore = defineStore('menu', {
    state: (): MenuState => ({
        // freeUser:[],
        // vipUser:[],
        // enterpriseAdmin:[],
        // enterpriseUser:[],
        userMenu:[],
        currentMenu:null
    }),
    getters:{
        getUserMenu:(state)=>{
            if (!state.userMenu || state.userMenu.length==0) {
                const userStore= useUserStore()
                const userInfo = userStore.getUser
                let userPermissions:MenuOwner[] = ['*','F']
                
                if(userInfo.it){
                    userPermissions.push('E')
                }
                if(userInfo.ia){
                    userPermissions.push('A')
                }
                if(userInfo.iv){
                    userPermissions.push('V')
                }
                
                const findFreeMenu = menus.filter(x=>userPermissions.includes(x.owner))
                if(findFreeMenu){
                    state.userMenu = findFreeMenu.map(x=>x.menu)
                }
            }
            return state.userMenu
        }
    },
    // actions:{
    //     setUserMenu()
    // }
})