import { ApiResult } from '@/configs/axios';
import { CustomerRate, CustomerThemeConfig } from '@/configs/customer';
import UserService from '@/services/UserService';
import { defineStore } from 'pinia';
import { StorageLike } from 'pinia-plugin-persistedstate';
import SecureLS from 'secure-ls';

const ls = new SecureLS({
    isCompression: false,
    encryptionSecret: '38c31684-d00d-30dc-82e0-fad9eec46d1d',
})
const st: StorageLike = {
    setItem(key: string, value: string) {
        ls.set(key, value);
    },
    getItem(key: string): string | null {
        return ls.get(key);
    },
}

export interface UserLoginResult {
    status:'ERROR'|'CHOSEN'|'SUCCESS',
    data?:any[]
}

export const useUserStore = defineStore('user', {
    state:()=>({
        token:'' as string,
        userInfo:{} as any
    }),
    getters: {
        getUserToken: (state) => {
          return state.token;
        },
        getUser: (state) => {
          return state.userInfo;
        },
        getUserTheme: (state) => {
            let rate:CustomerRate = 'FREE'
            if(state.userInfo.it) rate = 'EN'
            else if(state.userInfo.iv) rate = 'VIP'

            const theme = CustomerThemeConfig.find(x=>x.name==rate)
            return theme
        },
    },
    actions:{
        async setUserAutoLoginAsync(userId:number){
            try {
                let response = await UserService.AutoLoginAsync(userId)
                if (response.data.resultCode == ApiResult.SUCCESS) {
                    const d = response.data.data
                    this.token = d.token
                    d.nickname=d.emName
                    d.photo = d.Icon
                    d.company = d.GroupName
                    d.logo = d.GroupPic
                    d.isTemplate = d.IsEditTripTemplate
                    d.ia = 0
                    d.it = true
                    this.userInfo = d
                    
                    return true
                }
            } catch (error) {}
            return false
        },
        setUserLoginOut(){
            this.token=''
            this.userInfo={}
            window.location.href='/login'
        },
        async setUserPasswordLoginAsync(account:string,pwd:string,tid:string='') {
            try {
                let response = await UserService.PasswordLoginAsync(account,pwd,tid)
                if (response.data.resultCode == ApiResult.SUCCESS) {
                    if(!Array.isArray(response.data.data)) {
                        this.token = response.data.data.token
                        this.userInfo = response.data.data.userinfo
                        return { status:'SUCCESS' } as UserLoginResult
                    } else {
                        return { status:'CHOSEN', data:response.data.data } as UserLoginResult
                    }
                    
                }
            } catch (error) {}
            return { status:'ERROR' } as UserLoginResult
        }
    },
    persist: {
        storage: st,
    }
});