import { domainManager } from "../domainManager";

class AliyunUpload {
    static UploadAsync = async (file:any,name:string)=>{
        try {
            const formData = new FormData();
            formData.append('file', file);
            const response = await fetch(`${domainManager().UploadUrl}/Upload/UploadToALiOSS?filePath=${encodeURIComponent(name)}`, {
              method: 'POST',
              body: formData,
            });
            if(response.ok){
                let result = await response.text()
                let datas = JSON.parse(result)
                return 'https://im.oytour.com'+datas.FilePath
            }
            return ''
        } catch (error) {
            return ''
        }
    }
}

export default AliyunUpload