export type CustomerRate = 'FREE'|'VIP'|'EN'|'TME'
export interface CustomerTheme{
    name:CustomerRate,
    bg:string,
    color:string,
    desc:string
}
export interface MemberRights{
    name:string,
    value:string,
    sub?:string,
    range:('F'|'P'|'E')[]
}

export const FREE_USER_THEME:CustomerTheme = {name:'FREE',bg:'linear-gradient(270deg, #94A3C0 0%, #99A3B8 100%)',color:'#94a3c0', desc:'个人·免费版'}
export const VIP_USER_THEME:CustomerTheme = {name:'EN',bg:'linear-gradient(270deg, #4165E2 0%, #5276F5 100%)',color:'#dd9b38', desc:'组织/企业·专业版'}
export const ENT_USER_THEME:CustomerTheme = {name:'VIP',bg:'linear-gradient(270deg, #DD9B38 0%, #E6B351 100%)',color:'#252860', desc:'个人·专业版'}
export const TME_USER_THEME:CustomerTheme = {name:'TME',bg:'linear-gradient(270deg, #DD9B38 0%, #E6B351 100%)',color:'#252860', desc:'会员版·模版'}

export const CustomerThemeConfig:CustomerTheme[] = [FREE_USER_THEME,VIP_USER_THEME,ENT_USER_THEME,TME_USER_THEME] 

export const USER_DEFAULT_HEADER = 'https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Goods/1713839840000_239.png'
export const ENTERPRISE_DEFAULT_HEADER = 'https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Goods/1714387862000_894.png'

const ALL_MEMBER_RIGHTS:MemberRights[]=[
    {name:'创建行程数量',value:'1',sub:'(无法上传自有模板)',range:['F']},
    {name:'云盘空间',value:'100MB',range:['F']},
    {name:'POI图库',value:'10次',range:['F']},
    {name:'PDF水印',value:'系统标识',range:['F']},
    {name:'图片水印',value:'系统标识',range:['F']},
    {name:'VIP模板',value:'no',range:['F']},
    {name:'创建行程数量',value:'无限制',range:['E','P']},
    {name:'云盘空间',value:'10GB',range:['P']},
    {name:'企业共享空间',value:'50GB',range:['E']},
    {name:'POI图库',value:'无限制',range:['E','P']},
    {name:'PDF水印',value:'可去除',range:['E','P']},
    {name:'图片水印',value:'可去除',range:['E','P']},
    {name:'VIP模板',value:'yes',range:['E','P']},
    {name:'历史版本记录',value:'yes',range:['E','P']},
    {name:'POI资料卡',value:'yes',range:['E','P']},
    {name:'行程快速构建工具',value:'yes',range:['E','P']},
    {name:'地图插件',value:'yes',range:['E','P']},
    {name:'自动报价工具',value:'yes',range:['E','P']},
    {name:'私有模板管理',value:'yes',range:['E','P']},
    {name:'文件找回',value:'yes',range:['E','P']},
    {name:'内部共享行程',value:'yes',range:['E']}
]

export const FreeMemberRight = ALL_MEMBER_RIGHTS.filter(x=>x.range.includes('F'))
export const PersonMemberRight = ALL_MEMBER_RIGHTS.filter(x=>x.range.includes('P'))
export const EntMemberRight = ALL_MEMBER_RIGHTS.filter(x=>x.range.includes('E'))