import Api,{ HttpResponse, Result } from './../utils/request';

/**
 * 配置相关方法
 */
class ConfigService{

    /**
     * 手动生成行程文件
     */
     static async CreateTripFile(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_CreateTripFile",params)
    }

     /**
     * 获取行程广告最近版本
     */
      static async GetTripBrowsePage(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripBrowsePage",params)
    }

    /**
     * 新增修改最近浏览
     */
     static async SetTripBrowse(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_SetTripBrowse",params)
    }

     /**
     * 历史版本详情
     */
      static async GetHistoryInfo(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetHistoryInfo",params)
    }

    /**
     * 历史版本另存、替换
     */
    static async UpdateOtherByHistory(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_UpdateOtherByHistory",params)
    }
    /**
     * 获取行程广告历史版本
     */
     static async GetFileHistory(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetFileHistory",params)
    }

    /**
     * 行程广告重命名
     */
     static async ReNameTripOther(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_ReNameTripOther",params)
    }
     
    /**
     * 分享销售模版详情
     */
     static async GetTripOtherByCode(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripOtherByCode",params)
    }

    /**
     * 销售模版详情
     */
     static async sellGetTemplateDetails(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripOther",params)
    }

    /**
     * 销售删除模版
     */
     static async sellSetRemoveTemplate(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_RemoveTripOther",params)
    }

    /**
     * 销售新增编辑模版
     */
     static async sellSetTemplate(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_SetTripOther",params)
    }

    /**
     * 获取销售模版列表
     */
     static async sellGetTripOtherPage(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripOtherPage",params)
    }

    
    /**
     * 关键词检索获取行程酒店 餐 景点
     */
     static async getSourceDatas(params : any):Promise<HttpResponse>{
        return Api.Post("hotel_post_GetSourceList",params)
    }

    /**
     * 根据ConfigId获取行程配置相关数据
     */
     static async triptemplateGetTripFiledData(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripFiledData",params)
    }

    /**
     * 根据团期配置编号获取行程详情
     */
     static async triptemplateGetTripConfig(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripConfig",params)
    }

    /**
     * 新增修改模版数据
     */
     static async SetTripConfig(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_SetTripConfig",params)
    }

    /**
     * 删除模版
     */
     static async SetDeleteTripTemplate(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_RemoveTripTemplate",params)
    }

    /**
     * 新增修改模版
     */
     static async SetTripTemplateSlide(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_SetTripTemplate",params)
    }

    /**
     * 根据TempId获取模版数据
     */
     static async GetTripTemplateSlide(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripTemplate",params)
    }

    /**
     * 获取绑定数据源列表
     */
     static async TemplateGetTripFiled(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripFiled",params)
    }

    /**
     * 
     * @returns 获取模板查询条件 配置项数据(颜色、国家、季节)
     */
    static async GetTemplateQueryAsync(params:any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTemplateConfigData",params)
    }

    /**
     * 获取模板管理分页列表
     */
     static async GetManagerTripTemplatePage(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetManagerTripTemplatePage",params)
    }

    /**
     * 获取模板市场分页列表
     */
    static async GetTemplagePageAsync(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTripTemplatePage",params)
    }

    /**
     * 图片素材分页列表
     */
     static async GetPicList(params : any):Promise<HttpResponse>{
        return Api.Post("hotel_post_GetPicList",params)
    }

    /**
     * 新增国家
     */
     static async SetTemplateCountryData(params : any):Promise<HttpResponse>{
        return Api.Post("dict_post_Set",params)
    }

    /**
     * 新增颜色
     */
    static async SetTemplateConfigData(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_SetTemplateConfigData",params)
    }

    static async SetShareAsync(params:{ShareFileId:number,FileType:number,ShareList:{ShareType:number,ShareTargetIds:string,EditType:string}[]}):Promise<HttpResponse>{
        return Api.Post("triptemplate_SetTripShare",params)
    }
    
    static async GetShareAsync(FileId:number):Promise<HttpResponse>{
        let msg = {FileId}
        return Api.Post("triptemplate_GetTripShareDetails",msg)
    }
    
    static async RemoveShareAsync(ShareId:number):Promise<HttpResponse>{
        let msg = {ShareId}
        return Api.Post("triptemplate_RemoveTripShare",msg)
    }

    static async RemoveFileShareAsync(FileIdList:number[]):Promise<HttpResponse>{
        let msg = {FileIdList}
        return Api.Post("triptemplate_RemoveTripShareBatch",msg)
    }

    static async UpdateShareAsync(params:{ShareId:number,ShareTargetIds:string,EditType:string}):Promise<HttpResponse>{
        return Api.Post("triptemplate_EditTripShare",params)
    }

    static async SearchFileAsync(params:{FileType:number,FileName:string,pageSize:number, [key: string]: any}):Promise<HttpResponse>{
        params.pageIndex=1
        return Api.Post("triptemplate_HomeQuery",params)
    }

    static async QueryGiveMeShareDocumentAsync(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetShareMyFile",params)
    }
}
export default ConfigService;