import Api,{ HttpResponse, Result } from './../utils/request';


class OrderService{

    static async CreatePPTPayOrder(orderid:Number):Promise<HttpResponse>{
        let msg = {orderid}
        return Api.Post("ppt_CreatePPTPayOrder",msg)
    }

    static async CancelPPTOrder(orderid:Number):Promise<HttpResponse>{
        let msg = {orderid}
        return Api.Post("ppt_CancelPPTOrder",msg)
    }

    static async CreateOrderAsync(parameters:any):Promise<HttpResponse>{
        let msg = parameters
        return Api.Post("ppt_SetPPTOrder",msg)
    }

    static async GetOrders(params:any):Promise<HttpResponse>{
        let msg = params
        return Api.Post("ppt_GetPPTOrderPage",msg)
    }

    static async GetOrder(orderid:string):Promise<HttpResponse>{
        let msg = {orderid}
        return Api.Post("ppt_GetPPTOrderDetails",msg)
    }

    static async CreateTempOrderPaymentAsync(parameters:any):Promise<HttpResponse>{
        let msg = parameters
        return Api.Post("ppt_SetPPTTemplateOrder",msg)
    }

    static async GetOrderPayStatusAsync(no:any):Promise<HttpResponse>{
        let msg = {no}
        return Api.Post("ppt_order_pay_status",msg)
    }

    static async GetActiveTenantOrderAsync():Promise<HttpResponse>{
        let msg = {}
        return Api.Post("ppt_get_activetenantorder",msg)
    }

    static async SetTentantAsync(id:string,name:string):Promise<HttpResponse>{
        let msg = {id,name}
        return Api.Post("travel_create_tentant",msg)
    }
}
export default OrderService;