import { domainManager } from "../domainManager";
import { useUserStore } from "@/store";
import { storeToRefs } from 'pinia'
import { ElMessage } from "element-plus";
const { token } = storeToRefs(useUserStore())

class AliyunUpload {
    static UploadAsync = async (file: any, name: string) => {
        try {
            const formData = new FormData();
            formData.append('file', file);
            let parms = {
                istemp: 1,
                isppt: 1,
                uid: token.value
            }
            formData.append('parms', JSON.stringify(parms))
            const response = await fetch(`${domainManager().UploadUrl}/Upload/UploadToALiOSS?filePath=${encodeURIComponent(name)}`, {
                method: 'POST',
                body: formData,
            });
            if (response.ok) {
                let result = await response.text()
                let datas = JSON.parse(result)
                if(datas.FilePath) return 'https://im.oytour.com' + datas.FilePath
                else {
                    ElMessage.warning({
                        showClose: true,
                        message:datas.Message,
                    })
                }
            }
            return ''
        } catch (error) {
            return ''
        }
    }
    static UploadAvatar = async (file: any, filepath: string) => {
        try {
            const formData = new FormData();
            formData.append('file', file);
            const response = await fetch(`${domainManager().UploadUrl}/Upload?filePath=${encodeURIComponent(filepath)}`, {
                method: 'POST',
                body: formData,
            });
            if (response.ok) {
                let result = await response.text()
                let datas = JSON.parse(result)
                return 'https://im.oytour.com' + datas.FilePath
            }
            return ''
        } catch (error) {
            return ''
        }
    }
    static UploadCloudDisk= async (file: any, name: string, parms: any) => {
        try {
            const formData = new FormData();
            formData.append('file', file);
            if(parms&&parms.uid) formData.append('parms', JSON.stringify(parms));
            const response = await fetch(`${domainManager().UploadUrl}/Upload/UploadToALiOSS?filePath=${encodeURIComponent(name)}`, {
                method: 'POST',
                body: formData,
            });
            if (response.ok) {
                let result = await response.text()
                let datas = JSON.parse(result)
                if(datas.FilePath) return 'https://im.oytour.com' + datas.FilePath
                else {
                    ElMessage.warning({
                        showClose: true,
                        message:datas.Message,
                    })
                }
            }
            return ''
        } catch (error) {
            return ''
        }
    }
}

export default AliyunUpload