import { fa } from 'element-plus/es/locale'
import { defineStore } from 'pinia'

export interface ScreenState {
  screening: boolean,
  market:boolean,
  model:number,
  isModel: boolean,
  ConfigId:number,
  TemplateType: [],
  TemplateDataSource: [],
  TempId: number,
  CoverImg: any,
  isCoverImg: boolean,
  dataLoading: boolean,
  FeatureImg: any
  
}

export const useScreenStore = defineStore('screen', {
  state: (): ScreenState => ({
    screening: false, // 是否进入放映状态
    market: true,
    model: 0, // 是否有新增修改模版权限
    isModel: false, // 该团是否存在模版
    ConfigId: 0,
    TemplateType: [], // 数据源分类
    TemplateDataSource: [], // 所有数据源
    TempId: 0, // 模版Id
    CoverImg: null, // 封面图
    isCoverImg: false, // 封面
    dataLoading: false, // 记录保存是否成功
    FeatureImg: [], // 行程特色图
  }),

  actions: {
    setScreening(screening: boolean) {
      this.screening = screening
      if (screening) {
        this.market = false
      }
    },
    setMarket(market: boolean) {
      this.market = market
    },
    setModel(model: number) {
      this.model = model
    },
    setIsModel(isModel: boolean) {
      this.isModel = isModel
    },
    setConfigId(ConfigId: number) {
      this.ConfigId = ConfigId
    },
    setTemplateType(TemplateType: []) {
      this.TemplateType = TemplateType
    },
    setCoverImg(CoverImg: any) {
      this.CoverImg = CoverImg
    },
    setIsCoverImg(isCoverImg: boolean) {
      this.isCoverImg = isCoverImg
    },
    setTemplateDataSource(TemplateDataSource: []) {
      this.TemplateDataSource = TemplateDataSource
    },
    setTempId(TempId: number) {
      this.TempId = TempId
    },
    setDataLoading(dataLoading: boolean) {
      this.dataLoading = dataLoading
    },
    setFeatureImg(FeatureImg: any) {
      this.FeatureImg = FeatureImg
    }
  },
})