import { PPTImageElement } from '@/types/slides';
import { compressionThumbnail } from './compressor';

export const ResolveLayer = async (item: any, index: number,offsetLeft:number,offsetTop:number): Promise<PPTImageElement | null> => {

    //await compressionThumbnail(item.layer.image.toBase64(), "image/png", 0, 0.8)
    try {
        const src = await compressionThumbnail(item.layer.image.toBase64(), "image/png", 0, 0.8)//item.layer.image.toBase64()
        const left = item.coords.left-offsetLeft
        const width = item.coords.right - item.coords.left
        const top = item.coords.top-offsetTop
        const height = item.coords.bottom - item.coords.top
        const opacity = (parseFloat(item.layer.opacity) / 255.0).toFixed(2)

        let element: PPTImageElement = {
            id: "img_" + index,
            type: 'image',
            src,
            fixedRatio: false,
            filters: {
                opacity:src==''?'0':opacity
            },
            left,
            width,
            top,
            height,
            rotate: 0,
            lock: item.name.indexOf('editor')==-1 || (item.name.indexOf('editor')!=-1 && item.name.indexOf('before')!=-1)
        }

        return element
    } catch (error) { 
        console.log("执行出错",item)
        return null
    }
}