import { defineStore } from 'pinia'

export interface ScreenState {
  screening: boolean,
  market:boolean
}

export const useScreenStore = defineStore('screen', {
  state: (): ScreenState => ({
    screening: false, // 是否进入放映状态
    market: false
  }),

  actions: {
    setScreening(screening: boolean) {
      this.screening = screening
      if (screening) {
        this.market = false
      }
    },
    setMarket(market: boolean){
      this.market = market
    }
  },
})