
import { defineStore } from "pinia";
import {MapArcSeries,MapImageSeries,MapSplineSeries} from "@amcharts/amcharts4/maps";
import { Lang } from "@amcharts/amcharts4-geodata/.internal/Lang";

export interface MapFill{
    color:number,
    opacity:number,
    realColor:string
}

export interface MapCountryInfo{
    id:string,
    name:string,
    url:string
}

export interface MapCountryOpera{
    payload:any,
    exec:number
}

interface MapState{
    current:any,
    fillColor:MapFill,
    operaIndex:number,
    fillType:number,
    canOpera:boolean,
    newLine:number[],
    lineSeries:MapArcSeries|undefined,
    marker:string,
    removeMark:any,
    labelSeries:MapImageSeries|undefined,
    checkedCountries:MapCountryInfo[],
    allCountries:Lang|null,
    execut:MapCountryOpera|null
    splineSeries:MapSplineSeries|undefined
}

export const useMapStore = defineStore('map',{
    state:(): MapState => ({
        current:null,
        fillColor:{
            color:0x4bd8b5,
            opacity:1,
            realColor:'#4bd8b5'
        },
        operaIndex:0,
        fillType:1,
        canOpera:false,
        newLine:[],
        lineSeries:undefined,
        marker:'',
        removeMark:null,
        labelSeries:undefined,
        checkedCountries:[],
        allCountries:null,
        execut:null,
        splineSeries:undefined
    }),
    getters:{
        getCurrent(state){
            return state.current
        },
        getFillColor(state){
            return state.fillColor
        },
        getOperaIndex(state){
            return state.operaIndex
        },
        getFillType(state){
            return state.fillType
        },
        getMarker(state){
            return state.marker
        },
        getLang(state){
            return state.allCountries
        },
        getCheckedCountries(state){
            return state.checkedCountries
        },
        getAllCountries(state){
            return state.allCountries
        }
    },
    actions:{
        setCurrent(newVal:any){
            this.current = newVal
        },
        setFill(colorInfo:MapFill|any|undefined){
            this.fillColor=colorInfo
        },
        setOperaIndex(val:number){
            this.operaIndex = val
        },
        setFillType(val:number){
            this.fillType = val
        },
        setMarker(val:string){
            this.marker = val
        },
        removeCurrentLine(){
            if(this.lineSeries && this.current && this.current._className=='MapArc'){
                this.lineSeries.mapLines.removeValue(this.current)
                this.current = null
            }
        },
        removeCurrentSpLine(){
            if(this.splineSeries && this.current && this.current._className=='MapArc'){
                this.splineSeries.mapLines.removeValue(this.current)
                this.current = null
            }
        },
        setRemoveMark(val:string) {
            this.removeMark = val
        },
        removeCurrentText(){
            if(this.labelSeries){
                this.labelSeries.mapImages.removeValue(this.current.parent)
                this.current = null
            }
        },
        setAllCountries(val:Lang){
            this.allCountries = val
        },
        setCheckedCountries(val:MapCountryInfo){
            this.checkedCountries.push(val)
        },
        clearCheckedCountries(){
            this.checkedCountries = []
        },
        setCountriesChange(val:MapCountryOpera|null){
            this.execut = val
        }
        // removeCurrentMark(){
        //     if(this.map && this.current && this.current._className=='MapImageSeries'){
        //         this.map.series.removeValue(this.current)
        //         this.current = null
        //     }
        // }
    }
})