import service, { ApiResult } from "../configs/axios";
import { useUserStore } from "@/store/user";
import md5 from "md5-ts";

export interface HttpResponse {
    status: number
    statusText: string
    data: Result
}

export interface Result {
    resultCode: ApiResult
    message: string
    data: any
    [key: string]: any
}

class Api{
    constructor(){ }
    static Post = (cmd:string,msg:any): Promise<HttpResponse>=>{
        let datas: any
        let language = 'zh_CN'
        let currencyCode = 'CNY' 
        datas = msg
        
        msg = datas??{}
        let token = useUserStore().getUserToken??''
        let key = ""
        let groupId = useUserStore().getUser?.groupId
        let timestamp = (new Date()).valueOf();
        var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
        var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
        var postData = {
            "groupId": groupId,
            "msg": msg,
            "cmd": cmd,
            "timestamp": timestamp,
            "token": token,
            "sign": md5Str,
            "locale": language,
            "currencyCode": currencyCode
        }
        return service.post('', postData)
    }
}

export default Api;
