import { ref } from 'vue'
import { storeToRefs } from 'pinia'
import { useSlidesStore, useScreenStore } from '@/store'

export default () => {
  const slidesStore = useSlidesStore()
  const sourceLoadingStore = useScreenStore()
  const { slides, slideIndex } = storeToRefs(slidesStore)
  const { SourceLoading } = storeToRefs(useScreenStore())

  // 数据源更新
  const setNewDatasList = (DataSource:any) => {
    sourceLoadingStore.setSourceLoading(false)
    const slidesData = slides.value
    // 更新Slides数据
    let savelides = [] as any
    let newSlides = [] as any
    const obj = slidesData.find((x,index) =>{
        return slideIndex.value == index
    })
    if(obj){
        obj.elements.forEach(x=>{
            let dataObj = DataSource.DataSourceList.find((y:any)=>{
                return y.id == x.id
            })
            if(dataObj){
                x = dataObj
            }
            savelides.push(x)
      })
        obj.elements = JSON.parse(JSON.stringify(savelides))
        slidesData.forEach((x:any,index)=>{
            if(slideIndex.value == index){
                x.pgaeType = DataSource.pgaeType
                x.elements = obj.elements
            }
            newSlides.push(x)
        })
        slidesStore.setSlides(newSlides)
    }
  }
  

  return {
    setNewDatasList,
  }
}