import { padStart } from 'lodash'

/**
 * 补足数字位数
 * @param digit 数字
 * @param len 位数
 */
export const fillDigit = (digit: number, len: number) => {
  return padStart('' + digit, len, '0')
}

/**
 * 判断设备
 */
export const isPC = () => {
  return !navigator.userAgent.match(/(iPhone|iPod|iPad|Android|Mobile|BlackBerry|Symbian|Windows Phone)/i)
}

export const query = (url?:string)=>{
  url = url??location.href
  let str = url.substr(url.indexOf('?') + 1)
  let json = {} as any
  const arr = str.split('&')
  for(let i = 0; i < arr.length; i++) {
    let item = arr[i].split('=')
    json[item[0]] = item[1]
  }
  return json
}

/**
 * 提取字符串中的文字
 */
export const getHtmlPlainText = (html_str:string) => {
  let re = new RegExp('<[^<>]+>', 'g')
  if (html_str) {
    let text = html_str.replace(re, '')
    return text
  } else {
    return ''
  }
}