import Api, { HttpResponse, Result } from './../utils/request';


class UserServices {

    static async ModifyUserPhoto(photo:String):Promise<HttpResponse>{
        let msg = {photo}
        return Api.Post("travel_ModifyUserPhoto",msg)
    }

    static async getPPTGroupStatic():Promise<HttpResponse>{
        let msg = {}
        return Api.Post("travel_PPTGroupStatic",msg)
    }

    static async getPPTUserStatic():Promise<HttpResponse>{
        let msg = {}
        return Api.Post("travel_PPTUserStatic",msg)
    }

    static async SetMembers(id:Number,utype:Number,account:Number,mail:String,phone:Number):Promise<HttpResponse>{
        let msg = {id,utype,account,mail,phone}
        return Api.Post("travel_SetMembers",msg)
    }

    static async GetMemberUserInfo():Promise<HttpResponse>{
        let msg = {}
        return Api.Post("travel_GetMemberUserInfo",msg)
    }

    static async setMyNickNamed(nk:string):Promise<HttpResponse>{
        let msg = {nk}
        return Api.Post("travel_SetMyNickName",msg)
    }

    static async setModifyUserPwd(oldpwd:Number,pwd:Number):Promise<HttpResponse>{
        let msg = {oldpwd,pwd}
        return Api.Post("travel_ModifyUserPwd",msg)
    }

    static async setBindUserEmail(mail:string,code:Number):Promise<HttpResponse>{
        let msg = {mail,code}
        return Api.Post("travel_BindUserEmail",msg)
    }

    static async AutoLoginAsync(t: string): Promise<HttpResponse> {
        let msg = { t }
        return Api.Post("travel_auto_login", msg)
    }

    static async CollectAsync(): Promise<HttpResponse> {
        let msg = {}
        return Api.Post("travel_collect", msg)
    }

    static async UserSignOutAsync(): Promise<HttpResponse> {
        let msg = {}
        return Api.Post("travel_set_signout", msg)
    }

    static async PasswordLoginAsync(account: string, pwd: string, v_token: string, tid: string = ''): Promise<HttpResponse> {
        let msg = { account, pwd, v_token, tid }
        return Api.Post("travel_login_password", msg)
    }

    // static async RegistUserByPassAsync(account:string,pwd:string,nickname:string,token:string,tid:string=''):Promise<HttpResponse>{
    //     let msg:any = {account,pwd,nickname,"v_token":token}
    //     if(tid!='') msg.tid = tid
    //     return Api.Post("travel_user_regist_pwd",msg)
    // }

    static async RegistUserAsync(mail: string, pwd: string, code: string, token: string, tid: string = ''): Promise<HttpResponse> {
        let msg: any = { mail, code, pwd, "v_token": token }
        if (tid != '') msg.tid = tid
        return Api.Post("travel_user_regist", msg)
    }

    static async GetProductAsync(): Promise<HttpResponse> {
        let msg = { pageIndex: 1, pageSize: 100 }
        return Api.Post("ppt_GetPPTProduct", msg)
    }
    //
    static async SetMemberInfoAsync(nk: string, id: string, ia: 0 | 1 | -1): Promise<HttpResponse> {
        let msg = { nk, id, ia }
        return Api.Post("travel_set_member_info", msg)
    }

    static async RemoveMemberAsync(id: string): Promise<HttpResponse> {
        let msg = { id }
        return Api.Post("travel_remove_member", msg)
    }

    static async SetTenantSAAsync(id: string): Promise<HttpResponse> {
        let msg = { id }
        return Api.Post("travel_set_sa", msg)
    }

    static async SetTenantInviteCodeAsync(ia: 0 | 1): Promise<HttpResponse> {
        let msg = { ia }
        return Api.Post("travel_set_invite_code", msg)
    }

    static async JoinTeamByInviteCodeAsync(code: string): Promise<HttpResponse> {
        let msg = { code }
        return Api.Post("travel_set_join_code", msg)
    }

    static async ValidateInviteCodeAsync(code: string): Promise<HttpResponse> {
        let msg = { code }
        return Api.Post("travel_validate_invite", msg)
    }
    //
    static async UserExitTenantAsync(): Promise<HttpResponse> {
        let msg = {}
        return Api.Post("travel_set_userexit_tenant", msg)
    }
    static async GetTripSampleCountAsync(): Promise<HttpResponse> {
        let msg = {}
        return Api.Post("travel_sample_count", msg)
    }
    static async SendRegistCodeAsync(mail: string,isbind:any): Promise<HttpResponse> {
        let msg = { mail,isbind }
        return Api.Post("travel_regist_mail", msg)
    }
    static async NeedVerifyStatusAsync(): Promise<HttpResponse> {
        let msg = {}
        return Api.Post("travel_login_verify", msg)
    }
    static async SendResetPassCodeAsync(mail: string): Promise<HttpResponse> {
        let msg = { mail }
        return Api.Post("travel_forgot_pass", msg)
    }
    static async VerifyResetPassCodeAsync(mail: string, code: string, v_token: string): Promise<HttpResponse> {
        let msg: any = { code }
        if (mail != '') msg.mail = mail
        if (v_token != '') msg.v_token = v_token
        return Api.Post("travel_verify_forgotcode", msg)
    }
    static async ResetPasswordAsync(pw: string, v_token: string): Promise<HttpResponse> {
        let msg: any = { pw, v_token }
        return Api.Post("travel_reset_password", msg)
    }

    //测试接口方法
    // static async TestMethodAsync(cmdStr: string, postMsg: string): Promise<HttpResponse> {
    //     return Api.Post(cmdStr, postMsg)
    // }
}
export default UserServices;