import { defineStore } from "pinia"
import { useUserStore } from "./user"

export interface Menu{
    name:string,
    icon:string,
    url:string,
    children?:Menu[]
}
export type MenuOwner = '*'|'F'|'V'|'A'|'E'|'M'
export interface MenuState {
    userMenu:Menu[]
    temMenu: Menu[]
    currentMenu: Menu|null
}

const menus:{menu:Menu,owner:MenuOwner}[] = [
    {menu:{name:'账号一览',icon:'IconEarth',url:'/u'},owner:'*'},
    {menu:{name:'水印设置',icon:'IconTag',url:'/u/w'},owner:'*'},
    {menu:{name:'订单/发票',icon:'IconCurrency',url:'/u/order'},owner:'*'},
    {menu:{name:'账户设置',icon:'IconProtect',url:'/u/setting'},owner:'*'},
    {menu:{name:'模版管理',icon:'IconPageTemplate',url:'/m'},owner:'M'},
    {menu:{name:'国家',icon:'IconWorld',url:'/m/nation'},owner:'M'},
    {menu:{name:'颜色',icon:'IconPlatte',url:'/m/colour'},owner:'M'},
    {menu:{name:'字体',icon:'IconAddText',url:'/m/font'},owner:'M'},
    {menu:{name:'账号一览',icon:'IconEarth',url:'/a'},owner:'A'},
    {menu:{name:'成员管理',icon:'IconPeoples',url:'/a/u'},owner:'A'},
    {menu:{name:'数据统计',icon:'IconDashBoard',url:'/a/d'},owner:'A'},
    {menu:{name:'水印设置',icon:'IconTag',url:'/a/w'},owner:'A'},
    {menu:{name:'订单/发票',icon:'IconCurrency',url:'/a/order'},owner:'E'},
    {
        menu:{
            name:'更多设置 ',
            icon:'IconSettingOne',
            url:'',
            children:[
                {name:'基本信息',icon:'',url:'/a/info'},
                {name:'解散团队或企业',icon:'',url:'/a/diss'}
            ]
        },
        owner:'A'
    },
]

export const useMenuStore = defineStore('menu', {
    state: (): MenuState => ({
        userMenu:[],
        temMenu:[],
        currentMenu:null
    }),
    getters:{
        getUserMenu:(state)=>{
            const userStore= useUserStore()
            const userInfo = userStore.getUser
            if (!state.userMenu || state.userMenu.length==0) {
                let userPermissions:MenuOwner[] = ['F','*']
                
                // if(userInfo.it){
                //     userPermissions.push('E')
                // }
                // if(userInfo.ia){
                //     userPermissions.push('A')
                // }
                // if(userInfo.iv){
                //     userPermissions.push('V')
                // }
                // if(userInfo.isTemplate){
                //     userPermissions.push('M')
                // }
                const findFreeMenu = menus.filter(x=>userPermissions.includes(x.owner))
                if(findFreeMenu){
                    state.userMenu = findFreeMenu.map(x=>x.menu)
                }
            }
            return state.userMenu
        },
        getTemplateMenu:(state)=>{
            let userPermissions:MenuOwner[] = ['M']
            const findFreeMenu = menus.filter(x=>userPermissions.includes(x.owner))
            if(findFreeMenu){
                state.temMenu = findFreeMenu.map(x=>x.menu)
            }
            return state.temMenu
        },
        getTeamMenu:(state)=>{
            const userStore= useUserStore()
            const userInfo = userStore.getUser
            let userPermissions:MenuOwner[] = ['A']
            if(userInfo.ic) userPermissions.push('E')
            if(userInfo.it && (userInfo.ia || userInfo.ic)){
                const finds = menus.filter(x=>userPermissions.includes(x.owner))
                return finds.map(x=>x.menu)
            }
            return new Array<Menu>()
        }
    },
    // actions:{
    //     setUserMenu()
    // }
})