import { array } from '@amcharts/amcharts4/core';
import Api,{ HttpResponse, Result } from './../utils/request';


class CloudDiskService{

    static async GetEmpByEmpNameKey(keyWord:string):Promise<HttpResponse>{
        let params = {keyWord}
        return Api.Post("ppt_GetEmpByEmpNameKey",params)
    }

    static async BatchCloudFileCopy(IdList:any,GId:string):Promise<HttpResponse>{
        let params = {IdList,GId}
        return Api.Post("ppt_BatchCloudFileCopy",params)
    }

    static async BatchCloudFileMove(IdList:any,GId:string):Promise<HttpResponse>{
        let params = {IdList,GId}
        return Api.Post("ppt_BatchCloudFileMove",params)
    }
    
    static async BatchRemoveCloudInfo(IdList:any):Promise<HttpResponse>{
        let params = {IdList}
        return Api.Post("ppt_BatchRemoveCloudInfo",params)
    }

    static async GetPPTistCloudInfoFileFormatCount(QUserType:number):Promise<HttpResponse>{
        let params = {QUserType}
        return Api.Post("ppt_GetPPTistCloudInfoFileFormatCount",params)
    }

    static async BaiduImageDefinition(params:any):Promise<HttpResponse>{
        return Api.Post("ppt_BaiduImageDefinition",params)
    }

    static async ImgDefinition(DetailsId:any):Promise<HttpResponse>{
        let params = { DetailsId }
        return Api.Post("ppt_ImgDefinition",params)
    }

    static async CloudFileCopy(params:any):Promise<HttpResponse>{
        return Api.Post("ppt_CloudFileCopy",params)
    }

    static async CloudFileMove(params:any):Promise<HttpResponse>{
        return Api.Post("ppt_CloudFileMove",params)
    }

    static async UpdateCloudInfoName(params:any):Promise<HttpResponse>{
        return Api.Post("ppt_UpdateCloudInfoName",params)
    }

    static async GetPPTCloudLists(GName:String):Promise<HttpResponse>{
        let msg = {GName}
        return Api.Post("ppt_GetPPTCloudList",msg)
    }

    static async GetPPTCloudInfoPages(params:any):Promise<HttpResponse>{
        return Api.Post("ppt_GetPPTCloudInfoPage",params)
    }

    static async CheckCloudInfo(parms:any):Promise<HttpResponse>{
        let msg = parms
        return Api.Post("ppt_CheckCloudInfo",msg)
    }

    static async RemovePPTCloudInfo(DetailsId:String):Promise<HttpResponse>{
        let msg = {DetailsId}
        return Api.Post("ppt_RemovePPTCloudInfo",msg)
    }

    static async GetPPTCloudList(GName:String):Promise<HttpResponse>{
        let msg = {GName}
        return Api.Post("ppt_GetMyCloudList",msg)
    }

    static async GetPPTCloudInfoPage(params:any):Promise<HttpResponse>{
        return Api.Post("ppt_GetMyPPTCloudInfoPage",params)
    }

    static async RemovePPTCloudGroup(Id:Number):Promise<HttpResponse>{
        let msg = {Id}
        return Api.Post("ppt_RemovePPTCloudGroup",msg)
    }

    static async SetPPTCloudGroup(params:any):Promise<HttpResponse>{
        return Api.Post("ppt_SetPPTCloudGroup",params)
    }

}
export default CloudDiskService;