class MapService {
    static queryPlaceInfoAsync = async (keyword: string): Promise<{ label: string, value: string, center: number[] }[]> => {
        let url = `https://api.mapbox.com/geocoding/v5/mapbox.places/${keyword}.json?types=place&access_token=pk.eyJ1IjoiYWxleDkwMTIiLCJhIjoiY2xtOGw4NHdkMGFndTNjcnFkeWZncGc2dyJ9.lVrAdPHE0Dg5zoWFidfj4Q`

        const response = await fetch(url)
        return new Promise(async (resolve) => {
            if (response.ok) {
                let data = await response.json()
                if (data.features && data.features.length > 0) {
                    let result: { label: string, value: string, center: number[] }[] = []
                    data.features.forEach((x: any) => {
                        result.push({
                            label: x.matching_text?`${x.matching_text}(${x.text})`:x.text,
                            value: x.id,
                            center: x.center
                        })
                    })
                    resolve(result)
                }
            }
            resolve([])
        })
    }
}

export default MapService