import { defineStore } from 'pinia'

export interface SalesState {
    SalesEditor: number,
    SalesBack: number,
    SalesTripId: string,
    SaleHashCode: string,
    SaleSearchPosition: any
}

export const useSellTemplateStore = defineStore('sales', {
  state: (): SalesState => ({
    SalesEditor: 0, // 1 新增模版 2编辑模版 3新增广告 4编辑广告
    SalesBack: 0,// 0 销售首页  1 模版首页
    SalesTripId: '', // 销售行程id
    SaleHashCode:'',
    SaleSearchPosition: null
  }),
  getters: {
    getSearchPosition (state) {
      return state.SaleSearchPosition
    }
  },
  actions: {
    setSalesEditor(SalesEditor: number) {
      this.SalesEditor = SalesEditor
    },
    setSalesBack(SalesBack: number) {
      this.SalesBack = SalesBack
    },
    setSalesTripId(SalesTripId: string) {
      this.SalesTripId = SalesTripId
    },
    setSaleHashCode(hash:string){
      this.SaleHashCode = hash
    },
    setSaleSearchPosition(value: any){
      this.SaleSearchPosition = value
    }
  },
})