import type { InjectionKey, Ref } from 'vue'

export type SlideScale = Ref<number>
export type SlideId = Ref<string>
export type RadioGroupValue = {
  value: Ref<string>
  updateValue: (value: string) => void
}
export interface TravelAatas {
  baseInfo:any,
  dinnerInfo?:TravelDetail[],
  hotelInfo?:TravelDetail[],
  scenicInfo?:TravelDetail[]
  [key: string]: any;
}
export interface TravelDetail {
  Id:number,
  Name:string,
  Describe:string,
  ImgList?:string[]
}
export type SlideDataSource = Ref<{
  ConfigId:number,
  DataSourceList?:Array<any>,
  DataSourceOverlay?:boolean,
  TravelAatas?:TravelAatas,
  [key: string]: any;
}>
export type RecycleBinDelete = Ref<{
  RecycleBinList:Array<any>,
  RecoveryManage:boolean,
}>
export type publicKey = Ref<{
  [key: string]: any;
}>
export type OperaKey = Ref<number>
export const injectKeySlideScale: InjectionKey<SlideScale> = Symbol()
export const injectKeySlideId: InjectionKey<SlideId> = Symbol()
export const injectKeyRadioGroupValue: InjectionKey<RadioGroupValue> = Symbol()
export const injectKeyDataSource: InjectionKey<SlideDataSource> = Symbol()
export const injectKeyTemplate: InjectionKey<SlideDataSource> = Symbol()
export const injectKeyMapOperaIndex: InjectionKey<OperaKey> = Symbol()
export const injectKeyRecycleBin: InjectionKey<RecycleBinDelete> = Symbol()
export const injectKeyPublic: InjectionKey<publicKey> = Symbol()