import Api,{ HttpResponse, Result } from './../utils/request';


class LineService{
    // 根据编号删除配置
    static async RemoveTemplateConfigData(ID : number):Promise<HttpResponse>{
        return Api.Post("triptemplate_RemoveTemplateConfigData",{ID})
    }
    // 批量设置颜色分类
    static async BatchSetColor(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_BatchSetColor",params)
    }
    // 获取管理配置项数据(颜色、国家、季节) 
    static async GetManagerTemplateConfigData(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetManagerTemplateConfigData",params)
    }
    // 获取配置项数据(颜色、国家、季节) Trip_Template_Color Trip_Template_Country Trip_Template_Season
    static async GetTemplateConfigDataList(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetTemplateConfigDataList",params)
    }
    // 获取颜色
    static async GetParentColor(params : any):Promise<HttpResponse>{
        return Api.Post("triptemplate_GetParentColor",params)
    }

    // 系列
    static async GetSeriesListAsync(params : any):Promise<HttpResponse>{
        return Api.Post("team_post_GetList",params)
    }

    // 线路
    static async GetLineListAsync():Promise<HttpResponse>{
        return Api.Post("line_post_GetAllList",{})
    }

    static async GetTripInfoAsync(configId:number):Promise<HttpResponse>{
        return Api.Post("travel_get_GetTravelConfigMakeInfo",{configId})
    }
}
export default LineService;