import { ResolveFonts } from './font';
import type { PPTElement, Slide } from '@/types/slides'
import { compressionThumbnail, cropImage } from "./compressor"
import { ResolveLayer } from './layer'
import { ResolveText } from './text'

let Z_INDEX = 0
export const ResolveThumbHandler = async (psd:any)=>{

    const { _children } = psd.tree()
    let imgs:Array<any> = []
    let imgBase64String = psd.image.toBase64()

    for (let i = 0; i < _children.length; i++) {
        
        Z_INDEX = 2000

        const item = _children[i];
        if(item.layer.artboard) {
            let cropImagePath = await cropImage(imgBase64String,"image/jpeg",item.layer.artboard().export().coords)
            let imagePath = await compressionThumbnail(cropImagePath,"image/jpeg",300)
            imgs.push(imagePath)
        }
    }
    
    return imgs
}

export const ResolvePsdToSliderHandler = async (psd:any) => {

    const ID_PREV = "import-slide-"
    let items:Array<any> = psd.tree().children().filter((x:any)=>x.layer.visible)
    let sliders:Array<Slide> = []
    
    if(items && items.length>0){

        for (let i = 0; i < items.length; i++) {
            
            const x = items[i];
            let t =CreateDefaultSlider(ID_PREV+i)
            const {_children} = x

            if(_children && _children.length>0){
                const {top,left} = x.layer.artboard().export().coords
                t.elements = (await GetSlidersHandler(_children,left,top)).reverse()
            }

            sliders.push(t)
        }

    }

    return sliders.filter(x=>x.elements && x.elements.length>0)
}

export const ResolveSliderFonts = (psd:any) => {

    let items:Array<any> = psd.tree().children().filter((x:any)=>x.layer.visible)
    let fonts:Array<any> = []
    
    if(items && items.length>0){
        fonts = GetFontHandler(items)
    }

    return Array.from(new Set(fonts))
}

const CreateDefaultSlider = (id:string):Slide =>{
    return {
        id,
        pageType:1,
        typeId: 0,
        elements:[],
        background: {
            type: 'solid',
            color: '#ffffff',
        },
    }
}

const GetSlidersHandler = async (child:any[],offsetLeft:number,offsetTop:number) : Promise<PPTElement[]> =>{

    let elements = [] as Array<PPTElement>

    for (let i = 0; i < child.length; i++) {
        const x= child[i]
        Z_INDEX--

        if(x.layer.typeTool){
            elements.push(ResolveText(x, Z_INDEX, offsetLeft, offsetTop))
        }
        else if(x.width && x.width>0 && x.layer.image){
            
            let ele = await ResolveLayer(x, Z_INDEX, offsetLeft, offsetTop)
            if(ele) elements.push(ele)
        }
        if(x._children && x._children.length>0){
            let childers = await GetSlidersHandler(x._children,offsetLeft,offsetTop) ?? []
            elements = elements.concat(childers)
        }
    }
    
    return elements
}

const GetFontHandler = (child:any[]) : any[] => {
    let fonts = []
    if(child && child.length>0){

        for (let i = 0; i < child.length; i++) {
            const x = child[i];
            
            if(x.layer.typeTool){
                let temp = ResolveFonts(x)
                if(temp && temp.length>0) fonts.push(...temp)
            }
            if(x._children && x._children.length>0){
                let childers = GetFontHandler(x._children) ?? []
                fonts = fonts.concat(childers)
            }
        }
    }

    return fonts
}
