
//index.js
//获取应用实例
const app = getApp()
var util = require('../../utils/util.js')

Page({
  data: {
    motto: 'Hello World',
    userInfo: {},
    hasUserInfo: false,
    canIUse: wx.canIUse('button.open-type.getUserInfo'),
    indicatorDots: true,
    vertical: false,
    autoplay: false,
    interval: 2000,
    duration: 500,
    loginState:true,
    dataInfo:{},
    todayMsg:{
      ConfigId:0,
      TCID:'',
      // Date: util.YYMMDD(new Date()),
      Date: '2019-11 - 02',
      
    },
    todayList:[],
    contactState:true,
    contactInfo:{},
  },
  //事件处理函数
  bindViewTap: function() {
    // wx.navigateTo({
    //   url: '../logs/logs'
    // })
  },
  onLoad: function () {
    // if (app.globalData.userInfo) {
    //   this.setData({
    //     userInfo: app.globalData.userInfo,
    //     hasUserInfo: true
    //   })
    // } else if (this.data.canIUse){
    //   // 由于 getUserInfo 是网络请求，可能会在 Page.onLoad 之后才返回
    //   // 所以此处加入 callback 以防止这种情况
    //   app.userInfoReadyCallback = res => {
    //     this.setData({
    //       userInfo: res.userInfo,
    //       hasUserInfo: true
    //     })
    //   }
    // } else {
    //   // 在没有 open-type=getUserInfo 版本的兼容处理
    //   wx.getUserInfo({
    //     success: res => {
    //       app.globalData.userInfo = res.userInfo
    //       this.setData({
    //         userInfo: res.userInfo,
    //         hasUserInfo: true
    //       })
    //     }
    //   })
    // }
    let that=this;
    let userInfo = (wx.getStorageSync('userInfo'))
    if (userInfo){
      that.setData({
        userInfo:userInfo,
        loginState:false
      })
      
    }
    that.getData();
  },
  closeState(e){
    this.setData({
      contactState:true,
    })
  },
  noThing(e){
  },
  goWeb(e){
    let info = e.currentTarget.dataset.item;
    let name = info.Name;
    wx.navigateTo({
      url: '/pages/webview/webview?name='+name
    })
  },
  getContact(e){
    
    let info = e.currentTarget.dataset.item;
    let type = e.currentTarget.dataset.type;
    let contactInfo = this.data.contactInfo;
    contactInfo.type = type;
    if(type==1){
      contactInfo.Name = info.Surname + info.Name;
      contactInfo.MobilePhone = info.MobilePhone;
      contactInfo.LdNum = info.LdNum;
      contactInfo.LdPhoto = info.LdPhoto;
      
    }
    if (type == 2) {
      contactInfo.Name = info.Surname + info.Name;
      contactInfo.MobilePhone = info.MobilePhone;
      contactInfo.DyNum = info.DyNum;
      contactInfo.LdPhoto = info.DyPhoto;
    }
    if (type == 3) {
      contactInfo.Name = info.Contact;
      contactInfo.MobilePhone = info.ContactNumber;
      contactInfo.DyNum =info.CustomerNum;
      contactInfo.LdPhoto = info.CustomerPhoto;
    }
    this.setData({
      contactState:false,
      contactInfo: contactInfo,
    })
  },
  getData(){
    let userInfo = this.data.userInfo;
    let msg={
      ConfigId:0,
      TCID:'7003',
      OrderId: userInfo.OrderId ? userInfo.OrderId:'',
      CityId: userInfo.DepartureCityId ? userInfo.DepartureCityId:''
    };
    app.$api('b2b_get_GetMXYTravelIndexInfo', msg).then(res => {
      if (res.CityList.length>0){
        res.CityList.forEach(item=>{
          item.all = parseInt(item.Score);
          item.grey = 5- parseInt(item.Score);
        })
      }
      let todayMsg = this.data.todayMsg;
      todayMsg.ConfigId = res.configId;
      todayMsg.TCID = res.tcid;
      
      this.setData({
        dataInfo:res,
        todayMsg: todayMsg
      })
      this.getToday();
    }).catch(err => { })
  },
  getToday(){
    let todayMsg = this.data.todayMsg;
    app.$api('b2b_get_GetMXYToDayTourList', todayMsg).then(res => {
     
      if (res.Status==1){
        this.setData({
          todayList: res.List
        })
      }
      
    }).catch(err => { })
  },
  goCard(){
    wx.navigateTo({
      url: '/pages/validateForm/validate/validate'
    })
  },
  getUserInfo: function(e) {
    app.globalData.userInfo = e.detail.userInfo
    this.setData({
      userInfo: e.detail.userInfo,
      hasUserInfo: true
    })
  }
})
