const app = getApp()
Page({
  /**
   * 页面的初始数据
   */
  data: {
    videoDetail: '',
    start: 0,
    current: 0,
    startTouch: '',
    startNum: '0',
    //其中的 视频url(videoUrl) 封面url(videoImageUrl) 头像url(headUrl) 的话大家自己填上就行
    videoList: [], //接口返回的视频列表。
    touch: false,
    touchStartTime: 0, //触摸开始时间
    touchEndTime: 0, // 触摸结束时间
    lastTapTime: 0, // 单击事件点击后要触发的函数
    lastTapTimeoutFunc: null,
    switchTo: true,
    sliderShow: true,
    showComment: false,
    height: app.globalData.videoContainerSize.height,
    pageIndex: 1,
    searchinput: '',
    conList: [],//评论列表
    hasMoreData: false,
    inputShowed: false,
    placeholder: '留下你的精彩评论吧',
    ReplyId: 0,
    index: 0,
    showDel: false,
    showDel2: false,
    delIndex: 0,
    delIndex1: 0,
    delIndex2: 0,
    ziji: false
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    var that = this;
    let objlist = decodeURIComponent(options.list)
    let list = JSON.parse(objlist);
    let index = options.index;
    this.setData({
      videoList: list,
      current: index
    })

  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {
    this.videoContext = wx.createVideoContext('videoplayer');
    this.setData({
      updateState: true
    })
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },


  // 下面主要模仿滑动事件
  touchstart: function (e) {
    this.setData({
      touchStartTime: e.timeStamp,
      showGuide: false
    })
    let startTouch = e.changedTouches[0]
    this.setData({
      startTouch: startTouch,
      touch: false
    })
  },
  touchmove: function (e) {
    let Y = e.changedTouches[0].pageY - this.data.startTouch.pageY;
  },
  touchend: function (e) {
    this.setData({
      touchEndTime: e.timeStamp
    })
    this.getDirect(this.data.startTouch, e.changedTouches[0])
  },
  touchcancel: function (e) {
    this.getDirect(this.data.startTouch, e.changedTouches[0])
  },
  // 计算滑动方向
  getDirect: function (start, end) {
    var X = end.pageX - start.pageX,
      Y = end.pageY - start.pageY;
    if (Math.abs(X) > Math.abs(Y) && X > 0) {
      console.log("left 2 right");
    } else if (Math.abs(X) > Math.abs(Y) && X < 0) {
      console.log("right 2 left");
    } else if (Math.abs(Y) > Math.abs(X) && Y > 40) {
      if (this.data.current > 0) {
        this.setData({
          touch: true,
          transitionOver: false
        })
        this.pre()
      } else {
        this.setData({
          current: 0
        })
      }
    } else if (Math.abs(Y) > Math.abs(X) && Y < -40) {
      if (this.data.current < this.data.videoList.length - 2) {
        this.setData({
          touch: true
        })
        this.next()
      } else {
        var startNum = parseInt(this.data.startNum) + 5;
        this.setData({
          startNum: startNum,
        })
        this.setData({
          current: this.data.videoList.length - 1
        })
      }
    }
  },
  // 播放上一个
  pre: function () {
    this.setData({
      current: this.data.current - 1,
      play: false,
      conList: []
    })
  },

  // 播放下一个
  next: function () {

    this.setData({
      current: this.data.current == 0 ? 1 : this.data.current + 1,
      play: false,
      conList: []
    })



  },
  //点击暂停/开始
  videoTap: function () {
    let that = this
    //获取video
    that.videoContext = wx.createVideoContext('videoplayer')
    if (that.data.play) {
      //开始播放
      setTimeout(() => {
        that.videoContext.play() //开始播放
      }, 0)
      that.setData({
        play: false
      })
    } else {
      //当play==false 显示图片 暂停
      setTimeout(() => {
        that.videoContext.pause() //暂停播放
      }, 0)
      that.setData({
        play: true
      })
    }
  },
  bindPlay: function () {
    this.setData({ play: false })
  },

  // 暂停播放
  bindPause: function () {
    this.setData({ play: true })
  },
  //播放条时间改表触发
  videoUpdate(e) {

    if (this.data.updateState) { //判断拖拽完成后才触发更新，避免拖拽失效
      let sliderValue = e.detail.currentTime / e.detail.duration * 100;
      if (e.detail.duration > 30) { //大于30s 显示进度条
        this.setData({ sliderShow: true })
      } else {
        this.setData({ sliderShow: false })
      }
      this.setData({
        sliderValue: sliderValue,
        duration: e.detail.duration
      })
    }
  },
  sliderChanging(e) {
    this.setData({
      updateState: false //拖拽过程中，不允许更新进度条
    })
  },
  //拖动进度条触发事件
  sliderChange(e) {
    if (this.data.duration) {
      this.videoContext.seek(e.detail.value / 100 * this.data.duration); //完成拖动后，计算对应时间并跳转到指定位置
      this.setData({
        sliderValue: e.detail.value,
        updateState: true //完成拖动后允许更新滚动条
      })
    }
  },

  // 喜欢和不喜欢
  videoLike: function () {
    let that = this;
    let userInfo = (wx.getStorageSync('userInfo'))
    let videoList = that.data.videoList;
    let current = that.data.current;

    let VideoId = videoList[current].Id;
    let IsMyLike = videoList[current].IsMyLike;
    let Type = IsMyLike == 0 ? 1 : 2;
    if (Type == 1) {
      videoList[current].IsMyLike = 1;
      videoList[current].LikeNum = videoList[current].LikeNum + 1;

    } else {
      videoList[current].IsMyLike = 0;
      videoList[current].LikeNum = videoList[current].LikeNum - 1;

    }

    that.setData({
      videoList: videoList
    })
    let msg = {
      'VideoId': VideoId,
      'Type': Type,
      'GuestId': userInfo.GuestId
    }
    app.$api_t('Video_post_SetLYQVideoLike', msg).then(res => {
      if (Type == 1) {
        wx.showToast({
          title: '添加到喜欢',
          icon: 'none',
          duration: 1000
        })
      } else {
        wx.showToast({
          title: '已从喜欢列表移除',
          icon: 'none',
          duration: 1000
        })
      }
    }).catch(err => {
      //如果接口调取失败 操作还原
      if (Type == 1) {
        videoList[current].IsMyLike = 0;
        videoList[current].LikeNum = videoList[current].LikeNum - 1;

      } else {
        videoList[current].IsMyLike = 1;
        videoList[current].LikeNum = videoList[current].LikeNum + 1;

      }
    })
  },
  personal: function (e) {
    var that = this;
    var pages = getCurrentPages(); // 当前页面
    var beforePage = pages[pages.length - 2]; // 前一个页面
    wx.navigateBack({
      success: function () {
        beforePage.RefreshDate(that.data.videoList); // 执行前一个页面的onLoad方法
      }
    });
  },
  btnTx: function () {
    let that = this;
    that.setData({
      showComment: true,
      conList: [],
      searchinput: '',
      placeholder: '留下你的精彩评论吧',
      ReplyId: 0
    })
    console.log(that.data.videoList)
    console.log(that.data.current)
    let userInfo = (wx.getStorageSync('userInfo'))
    let VideoId = that.data.videoList[that.data.current].Id
    let msg = {
      'pageIndex': that.data.pageIndex,
      'pageSize': 20,
      'VideoId': VideoId,
      'ParentId': 0, //上级评论id 没有的话传0
      'OrderBy': 'LikeNum',
      'GuestId': userInfo.GuestId
    }
    //获取评论列表
    app.$api('Video_get_GetLYQVideoCommentPageList', msg).then(res => {
      let data = []
      for (let i = 0; i < res.pageData.length; i++) {
        res.pageData[i].showChildren = false;
        res.pageData[i].ChildrenList = [];
        res.pageData[i].UpdateDate = that.timeago((new Date(res.pageData[i].UpdateDate)).getTime())
        data.push(res.pageData[i])
      }

      if (res.pageData.length < 20) {
        that.setData({
          conList: that.data.conList.concat(data),
          hasMoreData: false
        })
      } else {
        that.setData({
          conList: that.data.conList.concat(data),
          hasMoreData: true,
          workIndex: that.data.pageIndex + 1
        })

      }

    }).catch(err => { })
  },
  closeCon: function () {
    this.setData({
      showComment: false,
      conList: []
    })
  },
  bindinput: function (e) {
    this.setData({
      searchinput: e.detail.value
    })
  },
  btn_c: function () {
    let that = this;
    let userInfo = (wx.getStorageSync('userInfo'))
    let VideoId = that.data.videoList[that.data.current].Id
    let msg = {
      'Content': that.data.searchinput,
      'VideoId': VideoId,
      'ParentId': that.data.ReplyId, //不是回复消息传0 回复消息传回复评论的id
      'GuestId': userInfo.GuestId
    }
    //发布列表
    app.$api('Video_post_SetLYQVideoCommentInfo', msg).then(res => {
      wx.showToast({
        title: '评论成功',
        icon: 'none',
        duration: 1000
      })
      if (that.data.placeholder == '留下你的精彩评论吧') {
        that.btnTx()
      } else {
        that.openChildren()
      }
      that.setData({
        searchinput: '',
        placeholder: '留下你的精彩评论吧',
        ReplyId: 0
      })



    }).catch(err => { })
  },
  loadMore: function () {
    console.log('上拉成功')
    if (this.data.hasMoreData) {
      this.btnTx()
    } else {
      // wx.showToast({
      //   title: '没有更多数据',
      //   icon:'none'
      // })
    }

  },
  //回复别人
  ReplyPeople: function (e) {
    var that = this;
    let index = e.currentTarget.dataset.index;
    let conList = that.data.conList;
    let Name = conList[index].EmName != '' ? conList[index].EmName : '匿名';
    conList[index].RevertNum = conList[index].RevertNum + 1;
    conList[index].showChildren = true;
    that.setData({
      inputShowed: true,
      placeholder: '@' + Name,
      ReplyId: conList[index].Id,
      index: index,
      conList: conList
    })
  },
  openChildren: function (e) {
    var that = this;
    let index;
    if (e != undefined) {
      index = e.currentTarget.dataset.index;
    } else {
      index = that.data.index
    }

    let conList = that.data.conList;
    let userInfo = (wx.getStorageSync('userInfo'))
    let VideoId = that.data.videoList[that.data.current].Id
    let pageSize = conList[index].RevertNum + 1
    let msg = {
      'pageIndex': 1,
      'pageSize': pageSize,
      'VideoId': VideoId,
      'ParentId': conList[index].Id, //上级评论id 没有的话传0
      'OrderBy': 'LikeNum',
      'GuestId': userInfo.GuestId
    }
    //获取评论列表
    app.$api('Video_get_GetLYQVideoCommentPageList', msg).then(res => {

      let data = [];
      for (let i = 0; i < res.pageData.length; i++) {
        res.pageData[i].UpdateDate = that.timeago((new Date(res.pageData[i].UpdateDate)).getTime())
        data.push(res.pageData[i])
      }
      conList[index].showChildren = true;
      conList[index].ChildrenList = data;
      that.setData({
        conList: conList
      })

    }).catch(err => { })
  },
  activeFocus: function (e) {
    if (e.detail.height == 0) {
      this.setData({
        searchinput: '',
        placeholder: '留下你的精彩评论吧',
        ReplyId: 0
      })
    }
  },
  dianzan: function (e) {
    var that = this;
    let index = e.currentTarget.dataset.index
    let conList = that.data.conList;
    let userInfo = (wx.getStorageSync('userInfo'))
    let CommentId = conList[index].Id;
    let IsMyLike = conList[index].IsMyLike;
    let Type = IsMyLike == 0 ? 1 : 2;
    if (Type == 1) {
      conList[index].IsMyLike = 1;
      conList[index].LikeNum = conList[index].LikeNum + 1;

    } else {
      conList[index].IsMyLike = 0;
      conList[index].LikeNum = conList[index].LikeNum - 1;

    }
    that.setData({
      conList: conList
    })
    let msg = {
      'CommentId': CommentId,
      'Type': Type,
      'GuestId': userInfo.GuestId
    }

    app.$api('Video_post_SetLYQVideoCommentLike', msg).then(res => {

    }).catch(err => {

      if (Type == 1) {
        conList[index].IsMyLike = 0;
        conList[index].LikeNum = conList[index].LikeNum - 1;

      } else {
        conList[index].IsMyLike = 1;
        conList[index].LikeNum = conList[index].LikeNum + 1;

      }
      that.setData({
        conList: conList
      })
    })
  },
  dianzan2: function (e) {
    console.log(e.currentTarget.dataset)
    var that = this;
    let index1 = e.currentTarget.dataset.index1;
    let index2 = e.currentTarget.dataset.index2;

    let conList = that.data.conList;
    let userInfo = (wx.getStorageSync('userInfo'))
    let CommentId = conList[index1].ChildrenList[index2].Id;
    let IsMyLike = conList[index1].ChildrenList[index2].IsMyLike;
    let Type = IsMyLike == 0 ? 1 : 2;
    if (Type == 1) {
      conList[index1].ChildrenList[index2].IsMyLike = 1;
      conList[index1].ChildrenList[index2].LikeNum = conList[index1].ChildrenList[index2].LikeNum + 1;

    } else {
      conList[index1].ChildrenList[index2].IsMyLike = 0;
      conList[index1].ChildrenList[index2].LikeNum = conList[index1].ChildrenList[index2].LikeNum - 1;

    }
    that.setData({
      conList: conList
    })
    let msg = {
      'CommentId': CommentId,
      'Type': Type,
      'GuestId': userInfo.GuestId
    }
    app.$api('Video_post_SetLYQVideoCommentLike', msg).then(res => {

    }).catch(err => {

      if (Type == 1) {
        conList[index1].ChildrenList[index2].IsMyLike = 0;
        conList[index1].ChildrenList[index2].LikeNum = conList[index1].ChildrenList[index2].LikeNum - 1;

      } else {
        conList[index1].ChildrenList[index2].IsMyLike = 1;
        conList[index1].ChildrenList[index2].LikeNum = conList[index1].ChildrenList[index2].LikeNum + 1;

      }
      that.setData({
        conList: conList
      })
    })
  },
  handleLongPress: function (e) {
    this.setData({
      showDel: true,
      delIndex: e.currentTarget.dataset.index,
    })
  },
  handleLongPress2: function (e) {
    this.setData({
      showDel2: true,
      delIndex1: e.currentTarget.dataset.index1,
      delIndex2: e.currentTarget.dataset.index2,
      ziji: true
    })

  },
  closedel: function () {
    this.setData({
      showDel: false,
      showDel2: false,
      ziji: false
    })
  },
  delItem: function () {
    var that = this;
    let index = that.data.delIndex;
    let conList = that.data.conList;
    let userInfo = (wx.getStorageSync('userInfo'))
    let CommentId = conList[index].Id
    let msg = {
      'CommentId': CommentId,
      'GuestId': userInfo.GuestId
    }
    app.$api('Video_post_DelLYQVideoCommentInfo', msg).then(res => {

      conList.splice(index, 1)

      that.setData({
        conList: conList
      })

    }).catch(err => {


    })
  },
  delItem2: function () {
    var that = this;
    let index1 = that.data.delIndex1;
    let index2 = that.data.delIndex2;

    let conList = that.data.conList;
    let userInfo = (wx.getStorageSync('userInfo'))
    let CommentId = conList[index1].ChildrenList[index2].Id
    console.log(index1, index2, CommentId)
    let msg = {
      'CommentId': CommentId,
      'GuestId': userInfo.GuestId
    }
    app.$api('Video_post_DelLYQVideoCommentInfo', msg).then(res => {

      conList[index1].ChildrenList.splice(index2, 1)
      that.setData({
        conList: conList
      })

    }).catch(err => {


    })
  },
  timeago: function (dateTimeStamp) {   //dateTimeStamp是一个时间毫秒，注意时间戳是秒的形式，在这个毫秒的基础上除以1000，就是十位数的时间戳。13位数的都是时间毫秒。
    var minute = 1000 * 60;      //把分，时，天，周，半个月，一个月用毫秒表示
    var hour = minute * 60;
    var day = hour * 24;
    var week = day * 7;
    var halfamonth = day * 15;
    var month = day * 30;
    var now = new Date().getTime();   //获取当前时间毫秒
    var diffValue = now - dateTimeStamp;//时间差

    if (diffValue < 0) {
      return;
    }
    var minC = diffValue / minute;  //计算时间差的分，时，天，周，月
    var hourC = diffValue / hour;
    var dayC = diffValue / day;
    var weekC = diffValue / week;
    var monthC = diffValue / month;
    let result
    if (monthC >= 1 && monthC <= 3) {
      result = " " + parseInt(monthC) + "月前"
    } else if (weekC >= 1 && weekC <= 3) {
      result = " " + parseInt(weekC) + "周前"
    } else if (dayC >= 1 && dayC <= 6) {
      result = " " + parseInt(dayC) + "天前"
    } else if (hourC >= 1 && hourC <= 23) {
      result = " " + parseInt(hourC) + "小时前"
    } else if (minC >= 1 && minC <= 59) {
      result = " " + parseInt(minC) + "分钟前"
    } else if (diffValue >= 0 && diffValue <= minute) {
      result = "刚刚"
    } else {
      var datetime = new Date();
      datetime.setTime(dateTimeStamp);
      var Nyear = datetime.getFullYear();
      var Nmonth = datetime.getMonth() + 1 < 10 ? "0" + (datetime.getMonth() + 1) : datetime.getMonth() + 1;
      var Ndate = datetime.getDate() < 10 ? "0" + datetime.getDate() : datetime.getDate();
      var Nhour = datetime.getHours() < 10 ? "0" + datetime.getHours() : datetime.getHours();
      var Nminute = datetime.getMinutes() < 10 ? "0" + datetime.getMinutes() : datetime.getMinutes();
      var Nsecond = datetime.getSeconds() < 10 ? "0" + datetime.getSeconds() : datetime.getSeconds();
      result = Nyear + "-" + Nmonth + "-" + Ndate
    }
    return result;
  }

})