// pages/webview/webview.js
const app = getApp()
var util = require('../../../utils/util.js')
Page({

  /**
   * 页面的初始数据
   */
  data: {
    headerHeight: app.globalData.headerHeight,
    model:{},
    Selection:0,
    workslist:[],
    workIndex:1,
    likelist:[],
    likeIndex:1,
    height: app.globalData.videoContainerSize.height,
    hasMoreData:'',
    hasMoreData_l:''
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.setData({
      model: options
    })
    this.getUserInfo()  //获取用户信息
    this.getworkslist() //获取作品列表
    this.getlikelist() //获取喜欢列表
  },
  getUserInfo:function(){
    var that = this;;
    let model = that.data.model;
    let msg={
      'EmployeeId': model.CreateBy,
      'UserType': model.UserType,
    }
    app.$api_t('Video_get_GetVideoUserInfo', msg).then(res => {
     console.log(res)
      
    }).catch(err => {
      //如果接口调取失败 操作还原
      
    })
  },
  getworkslist:function(){
    var that = this;;
    let model = that.data.model;
    let userInfo = (wx.getStorageSync('userInfo'))

    let msg = {
      'pageIndex':that.data.workIndex,
      'pageSize':9,
      'CreateBy': model.CreateBy,
      'UserType': model.UserType,
      'VideoStatus':1,
      'GuestId': userInfo.GuestId,
    }
    app.$api_t('Video_get_GetLYQVideoPageList', msg).then(res => {
      if(res){
          if (res.pageData.length<9){
            that.setData({
              workslist: that.data.workslist.concat(res.pageData),
              hasMoreData: false
            })
          } else {
            that.setData({
              workslist: that.data.workslist.concat(res.pageData),
              hasMoreData: true,
              workIndex: that.data.workIndex+1
            })
          
        }
      }
      

    }).catch(err => {
      //如果接口调取失败 操作还原

    })
  },
  getlikelist: function () {
    var that = this;;
    let model = that.data.model;
    let userInfo = (wx.getStorageSync('userInfo'))

    let msg = {
      'pageIndex': that.data.likeIndex,
      'pageSize': 9,
      'CreateBy': model.CreateBy,
      'UserType': model.UserType,
      'VideoStatus': 1,
      'GuestId': userInfo.GuestId,
    }
    app.$api_t('Video_get_GetLYQMyLikeVideoPageList', msg).then(res => {
      if (res) {    
          if (res.pageData.length < 9) {
            that.setData({
              likelist: that.data.likelist.concat(res.pageData),
              hasMoreData_l: false
            })
          } else {
            that.setData({
              likelist: that.data.likelist.concat(res.pageData),
              hasMoreData_l: true,
              likeIndex: that.data.likeIndex + 1
            })
          }
        
      }

    }).catch(err => {
      //如果接口调取失败 操作还原

    })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {
  },


  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  works:function(){
    if (this.data.Selection==1){
      this.setData({
        Selection:0
      })
    }
  },
  like:function(){
    if (this.data.Selection == 0) {
      this.setData({
        Selection: 1
      })
    }
  },

  loadMore:function(){
    console.log('上拉成功')
    if (this.data.hasMoreData) {
      this.getworkslist()
    } else {
      // wx.showToast({
      //   title: '没有更多数据',
      //   icon:'none'
      // })
    }

  },
  loadMore_l:function(){
    if (this.data.hasMoreData_l) {
      this.getlikelist()
    } else {
      // wx.showToast({
      //   title: '没有更多数据',
      //   icon:'none'
      // })
    }
  },
  enterPlay:function(e){
    var that = this;
    let list;
    let index = e.currentTarget.dataset.index;
    if (that.data.Selection==0){
      list = encodeURIComponent(JSON.stringify(that.data.workslist)) 
    }else{
      list = encodeURIComponent(JSON.stringify(that.data.likelist))
    }
    wx.navigateTo({
      url: '/pages/video/video_t/video_t?list=' + list + '&index=' + index
    })
  },
  RefreshDate:function(e){ //更新数据
    var that = this;
    if (that.data.Selection == 0) {
      that.setData({
        workslist:e
      }) 
    }else{
      
      that.setData({
        likelist: e
      })
    }
  }

})