// pages/Clockin/Clockin.js
var util = require('../../utils/util.js')
var utilsNew = require('../../utils/utilsNew.js')
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    uploadimgList: [],
    msg: {
      Name: '22222wwww',
      Type: 1,
      SourceId: '2',
      Score: 0,
      Description: '',
      CreateBy: '37284',
      ImgList: [],
      VideoAddress: '',
      Cover: '',
    },
    grey: 5,
    index: false,
    videoUrl: '',
    videoContext:'',
    playVideoSrc:'',
    videoState: false,

  },
  videoContext: null,
  onReady: function (res) {
    
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    console.log("options", options)
    if (options.CreateBy) {
      let msg = this.data.msg;
      msg.CreateBy = options.CreateBy;
      msg.Name = options.Name;
      msg.SourceId = options.SourceId;
      msg.Type = options.Type;
      this.setData({
        msg: msg
      })
    }
    if (options.index) {
      this.setData({
        index: true
      })
    }
  },
  closeVideo(){
    this.setData({
      videoState: false,
    })
    this.videoContext = wx.createVideoContext('prew_video');
    this.videoContext.pause();
  },
  deleteVideo(){
    let msg=this.data.msg;
    msg.VideoAddress='';
    this.setData({
      msg:msg
    })
  },
  bindPreviewVideo(e) {
    let playVideoSrc =this.data.msg.VideoAddress;
    this.setData({
      videoState: true,
      playVideoSrc: playVideoSrc
    })
    this.videoContext = wx.createVideoContext('prew_video');
    this.videoContext.play();

  },
  bindVideoScreenChange: function ( e) {
    var status = e.detail.fullScreen;
    console.log(status)
    var play = {
      playVideo: false
    }
    if (status) {
      play.playVideo = true;
    } else {
      this.videoContext.pause();
    }
    this.setData(play);
  },
  upvideo() {
    var aliOssParams = utilsNew.utilNew.aliOssParams();
    //上传视频到阿里云
    var that = this;
    wx.chooseVideo({
      maxDuration: 10,
      success: function(res) {
        var tempFilePath = res.tempFilePath;
        var stringFilePath = String(tempFilePath);
        var indexType = stringFilePath.lastIndexOf('.');
        var type = stringFilePath.substring(indexType);
        var alikey = 'video/' + new Date().getTime() +
          Math.floor(Math.random() * 1000) + type; //随机1000内的数加上时间戳作为你存放在阿里云video目录下名字和类型。
        util.showToast('loading', '上传中', {
          duration: 1000 * 100
        })
        wx.uploadFile({
          url: aliOssParams.host,
          filePath: tempFilePath,
          name: 'file',
          formData: {
            name: tempFilePath,
            key: alikey, //这个是关键它是定义存放在阿里云那个目录下
            policy: aliOssParams.policy, //上传阿里云的加密策略
            OSSAccessKeyId: aliOssParams.aid, //自己阿里云的aid
            success_action_status: "200",
            signature: aliOssParams.signature, //上传阿里云的签名
          },
          success: function(res) {
            var videoUrl = aliOssParams.host + '/' + alikey; //这就是刚上传阿里云后的存放的地址链接，通过它打开你刚上传视频。
            that.videoUrl = videoUrl;
            let msg = that.data.msg;
            msg.VideoAddress = that.videoUrl;
            let lastUrl = "?x-oss-process=video/snapshot,t_9,f_jpg,w_210,h_0,m_fast";
            msg.Cover = that.videoUrl + lastUrl;
            msg.ImgList = [];
            that.setData({
              msg: msg,
              uploadimgList:[]
            })

            util.showToast('text', '上传成功!', {
              duration: 2000
            })

          },
          fail: function({
            errMsg
          }) {
            util.showToast('text', '上传失败!', {
              duration: 2000
            })

          },
        })
      }
    })
  },

  tiJiao() {
    let msg = this.data.msg;
    if (msg.Description == '') {
      util.showToast('text', '说些什么吧！', {
        duration: 2000
      })
      return;
    }
    app.$api('b2b_post_SetMXYToDayTourPunchCard', msg).then(res => {
      console.log("res", res)
      let pathUrl = (wx.getStorageSync('pathUrl'))
      if (this.data.index) {
        wx.switchTab({
          url: '/pages/index/index'
        })
      } else {
        wx.navigateTo({
          url: pathUrl
        })
      }

    }).catch(err => {})

  },
  bindinputText(e) {
    let val = e.detail.value;
    let msg = this.data.msg;
    msg.Description = val;
    this.setData({
      msg: msg
    })
  },
  scoreColor(e) {
    let index = e.currentTarget.dataset.index;
    let msg = this.data.msg;
    msg.Score = index;
    let grey = 5 - msg.Score;
    this.setData({
      msg: msg,
      grey: grey
    })
  },
  scoreGrey(e) {
    let index = e.currentTarget.dataset.index;
    let msg = this.data.msg;
    msg.Score = index + msg.Score;
    let grey = 5 - msg.Score;
    this.setData({
      msg: msg,
      grey: grey
    })
  },
  deleteImg(e) {
    let imgIndex = e.currentTarget.dataset.index;
    let that = this;
    let uploadimgList = that.data.uploadimgList;
    uploadimgList.splice(imgIndex, 1)
    let msg = that.data.msg;
    msg.ImgList = uploadimgList;
    that.setData({
      uploadimgList: uploadimgList,
      msg: msg,
    })
  },
  upload() {
    let that = this;
    let uploadimgList = that.data.uploadimgList;
    wx.chooseImage({
      sourceType: ['album', 'camera'],
      success: function(res) {
        setTimeout(() => {
          wx.showLoading({
            title: '上传中，请稍后',
            mask: true,
          })

          var tempFilePaths = res.tempFilePaths;
          wx.uploadFile({
            url: "https://upload.oytour.com/Upload?filePath=/Upload/Temporary/",
            filePath: tempFilePaths[0],
            name: 'file',
            formData: {
              'myfile': tempFilePaths[0],
            },
            // contentType:'multipart/form-data',
            success: function(res) {
              wx.hideLoading()
              if (res.statusCode == 200) {
                let url = "http://imgfile.oytour.com";

                // let uploadInfo = that.data.uploadInfo;
                let path = url + JSON.parse(res.data).FilePath;
                uploadimgList.push(path)
                let msg = that.data.msg;
                msg.ImgList = uploadimgList;
                msg.VideoAddress = '';
                msg.Cover='';
                that.setData({
                  uploadimgList: uploadimgList,
                  msg: msg
                })

              }
            },
            fail: function(res) {
              wx.hideLoading();
              util.showToast('text', '上传失败！', {
                duration: 2000
              })
            }

          })
        }, 300)


      }
    })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})