// pages/index/sceneDetail/sceneDetail.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    msg: {
      Id: '2',
      Type: 1,
      GuestId: '37284'
    },
    dataInfo: {},
    pathUrl:'',
    plList: [],
    videoState: false,
    playVideoSrc: "",
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log("options", options)
    let msg = this.data.msg;
    if (options.GuestId) {
      msg.GuestId = options.GuestId;
      msg.Id = options.Id;
      this.setData({
        msg: msg
      })
    }
    this.getData();
    this.getPinglunList();
    let pathUrl = '/pages/index/strateDateil/strateDateil?GuestId=' + msg.GuestId + '&Id=' + msg.Id;
    this.setData({
      pathUrl: pathUrl
    })
  },
  closeVideo() {
    this.setData({
      videoState: false,
    })
    this.videoContext = wx.createVideoContext('prew_video');
    this.videoContext.pause();
  },
  bindPreviewVideo(e) {
    let playVideoSrc = e.currentTarget.dataset.item.VideoAddress;
    this.setData({
      videoState: true,
      playVideoSrc: playVideoSrc
    })
    this.videoContext = wx.createVideoContext('prew_video');
    this.videoContext.play();

  },
  modeImg1(e) {
    let img = e.currentTarget.dataset.item.ImgList;
    wx.previewImage({
      current: img[0],
      urls: img,
      success: function (res) {
      }
    })
  },
  modeImg(e) {
    let img = [];
    img[0] = e.currentTarget.dataset.img;
    wx.previewImage({
      current: img[0],
      urls: img,
      success: function (res) {
      }
    })
  },
  DakaBtn(e) {
    let that = this;
    let info = that.data.msg;
    let Id = info.Id;
    let GuestId = info.GuestId;
    wx.navigateTo({
      url: '/pages/Clockin/Clockin?CreateBy=' + GuestId + '&SourceId=' + Id + '&Type=' + info.Type + '&Name=' + this.data.dataInfo.Name
    })
    wx.setStorageSync('pathUrl', this.data.pathUrl)
  },
  getData() {
    let msg = this.data.msg;
    app.$api('b2b_get_GetMXYToDayTourInfo', msg).then(res => {
      let content = res.Content;
      res.Content = content.replace(/\<img/gi, '<img style="width:100%;height:auto;border-radius:20rpx" ')
      console.log("res", res)
      this.setData({
        dataInfo: res
      })
    }).catch(err => { })
  },
  getPinglunList() {
    let msg = {};
    msg.pageIndex = 1;
    msg.pageSize = 100;
    msg.SourceId = this.data.msg.Id;
    msg.Type = this.data.msg.Type;
    app.$api('b2b_get_GetMXYPunchCardPageList', msg).then(res => {
      console.log("sfdasf", res)
      this.setData({
        plList: res.pageData
      })
    }).catch(err => { })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})