const app = getApp()
var util = require('../../../utils/util.js')
Page({
  /**
   * 页面的初始数据
   */
  data: {
    videoDetail: '',
    start: 0,
    current: 0,
    startTouch: '',
    startNum: '0',
    //其中的 视频url(videoUrl) 封面url(videoImageUrl) 头像url(headUrl) 的话大家自己填上就行
    videoList: [], //接口返回的视频列表。
    touch: false,
    touchStartTime: 0, //触摸开始时间
    touchEndTime: 0, // 触摸结束时间
    lastTapTime: 0, // 单击事件点击后要触发的函数
    lastTapTimeoutFunc: null,
    switchTo: true,
    sliderShow:true
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {

    var that = this;
    let objlist = decodeURIComponent(options.list)
    let list = JSON.parse(objlist);
    let index = options.index;
    this.setData({
      videoList: list,
      current:index
    })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {
    this.videoContext = wx.createVideoContext('videoplayer');
    this.setData({
      updateState: true
    })
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },
  dataList: function() { //加载数据
    let that= this;
    let userInfo = (wx.getStorageSync('userInfo'))
    let msg = { 'RecommendNum': 6, 'GuestId': userInfo.GuestId}
    app.$api('Video_get_GetLYQVideoRecommendCache', msg).then(res => {
        var listTem = that.data.videoList;
        var dataList = res;
        //添加新任务列表
        that.setData({
          videoList: listTem.concat(dataList)
        })
      if (that.data.videoList.length>0){
        this.videoWatch()
      }
      

    }).catch(err => { })
  },
  // 下面主要模仿滑动事件
  touchstart: function(e) {
    this.setData({
      touchStartTime: e.timeStamp,
      showGuide: false
    })
    let startTouch = e.changedTouches[0]
    this.setData({
      startTouch: startTouch,
      touch: false
    })
  },
  touchmove: function(e) {
    let Y = e.changedTouches[0].pageY - this.data.startTouch.pageY;
  },
  touchend: function(e) {
    this.setData({
      touchEndTime: e.timeStamp
    })
    this.getDirect(this.data.startTouch, e.changedTouches[0])
  },
  touchcancel: function(e) {
    this.getDirect(this.data.startTouch, e.changedTouches[0])
  },
  // 计算滑动方向
  getDirect: function(start, end) {
    var X = end.pageX - start.pageX,
      Y = end.pageY - start.pageY;
    if (Math.abs(X) > Math.abs(Y) && X > 0) {
      console.log("left 2 right");
    } else if (Math.abs(X) > Math.abs(Y) && X < 0) {
      console.log("right 2 left");
    } else if (Math.abs(Y) > Math.abs(X) && Y > 40) {
      if (this.data.current > 0) {
        this.setData({
          touch: true,
          transitionOver: false
        })
        this.pre()
      } else {
        this.setData({
          current: 0
        })
      }
    } else if (Math.abs(Y) > Math.abs(X) && Y < -40) {
      if (this.data.current < this.data.videoList.length - 2) {
        this.setData({
          touch: true
        })
        this.next()
      } else {
        var startNum = parseInt(this.data.startNum) + 5;
        this.setData({
          startNum: startNum,
        })
        // this.dataList();
        this.setData({
          current: this.data.videoList.length - 1
        })
      }
    }
  },
  // 播放上一个
  pre: function() {
    console.log()
    this.setData({
      current: this.data.current - 1,
      play:false
    })
  },

  // 播放下一个
  next: function() {
    this.setData({
      current: this.data.current + 1,
      play: false
    })
    this.videoWatch()
    
  },
  // 标记视频为已看
  videoWatch:function(){
    let that = this;
    let userInfo = (wx.getStorageSync('userInfo'))
    let VideoId = that.data.videoList[that.data.current].Id
    let msg = {
            'VideoId': VideoId,
            'Type':1 ,
            'GuestId': userInfo.GuestId 
     }
    app.$api_t('Video_post_SetLYQVideoWatch', msg).then(res => {
    
    }).catch(err => { })
  },
  //点击暂停/开始
  videoTap: function() {
    let that = this
    //获取video
    that.videoContext = wx.createVideoContext('videoplayer')
    if (that.data.play) {
      //开始播放
      setTimeout(()=>{
        that.videoContext.play() //开始播放
      },0)
      that.setData({
        play: false
      })
    } else {
      //当play==false 显示图片 暂停
      setTimeout(() => {
        that.videoContext.pause() //暂停播放
      },0)
      that.setData({
        play: true
      })
    }
  },
  bindPlay: function () {
    this.setData({ play: false })
  },

  // 暂停播放
  bindPause: function () {
    this.setData({ play: true })
  },
  //播放条时间改表触发
  videoUpdate(e) {
    
    if (this.data.updateState) { //判断拖拽完成后才触发更新，避免拖拽失效
      let sliderValue = e.detail.currentTime / e.detail.duration * 100;
      if (e.detail.duration>30){ //大于30s 显示进度条
        this.setData({ sliderShow:true})
      }else{
        this.setData({ sliderShow: false })
      }
      this.setData({
        sliderValue: sliderValue,
        duration: e.detail.duration
      })
    }
  },
  sliderChanging(e) {
    this.setData({
      updateState: false //拖拽过程中，不允许更新进度条
    })
  },
  //拖动进度条触发事件
  sliderChange(e) {
    if (this.data.duration) {
      this.videoContext.seek(e.detail.value / 100 * this.data.duration); //完成拖动后，计算对应时间并跳转到指定位置
      this.setData({
        sliderValue: e.detail.value,
        updateState: true //完成拖动后允许更新滚动条
      })
    }
  },

  // 喜欢和不喜欢
  videoLike:function(){
    let that = this;
    let userInfo = (wx.getStorageSync('userInfo'))
    let videoList = that.data.videoList;
    let current = that.data.current;

    let VideoId = videoList[current].Id;
    let IsMyLike = videoList[current].IsMyLike;
    let Type = IsMyLike == 0 ? 1 : 2;
    if (Type==1){
      videoList[current].IsMyLike=1;
      videoList[current].LikeNum = videoList[current].LikeNum+1;
     
    }else{
      videoList[current].IsMyLike = 0;
      videoList[current].LikeNum = videoList[current].LikeNum - 1;
      
    }
    
    that.setData({
      videoList: videoList 
    })
    let msg = {
      'VideoId': VideoId,
      'Type': Type,
      'GuestId': userInfo.GuestId
    }
    app.$api_t('Video_post_SetLYQVideoLike', msg).then(res => {
      if (Type == 1){
        wx.showToast({
          title: '添加到喜欢',
          icon: 'none',
          duration: 1000
        })
      }else{
        wx.showToast({
          title: '已从喜欢列表移除',
          icon: 'none',
          duration: 1000
        })
      }
    }).catch(err => {
      //如果接口调取失败 操作还原
      if (Type == 1) {
        videoList[current].IsMyLike = 0;
        videoList[current].LikeNum = videoList[current].LikeNum - 1;

      } else {
        videoList[current].IsMyLike = 1;
        videoList[current].LikeNum = videoList[current].LikeNum + 1;

      }
     })
  },
  personal:function(e){

    var that = this;
    var pages = getCurrentPages(); // 当前页面
    var beforePage = pages[pages.length - 2]; // 前一个页面
    wx.navigateBack({
      success: function () {
        beforePage.RefreshDate(that.data.videoList); // 执行前一个页面的onLoad方法
      }
    });
  },
  
})