const app = getApp()
Page({
  /** 
   * 页面的初始数据 
   */
  data: {
    isActive: null,
    listMain: [],
    listTitles: [],
    fixedTitle: null,
    toView: 'inToView0',
    oHeight: [],
    scroolHeight: 0,
    msg: {
      TCID: '7003'
    },
    choosetype:0,
  },
  //点击右侧字母导航定位触发
  scrollToViewFn: function(e) {
    var that = this;
    var _id = e.target.dataset.id;
    for (var i = 0; i < that.data.listMain.length; ++i) {
      if (that.data.listMain[i].id === _id) {
        that.setData({
          isActive: _id,
          toView: 'inToView' + _id
        })
        break
      }
    }
  },
  toBottom: function(e) {
    
  },
  getPerson(e){
    console.log("e",e);
    let info = e.currentTarget.dataset.item;
    let choosetype = this.data.choosetype;
    let TCID = this.data.msg.TCID;
    wx.navigateTo({
      url: `/pages/validateForm/yzCard/yzCard?Name=${info.Name}&IdCard=${info.IdCard}&PassportNo=${info.PassportNo}&choosetype=${choosetype}&TCID=${TCID}`,
    })

  },
  // 页面滑动时触发
  onPageScroll: function(e) {
    this.setData({
      scroolHeight: e.detail.scrollTop
    });
    for (let i in this.data.oHeight) {
      if (e.detail.scrollTop < this.data.oHeight[i].height) {
        this.setData({
          isActive: this.data.oHeight[i].key,
          fixedTitle: this.data.oHeight[i].name
        });
        return false;
      }
    }

  },
  getData() {
    let that=this;
    app.$api('b2b_get_GetMXYTravelGuestInfo', this.data.msg).then(res => {
      let arr=[];
      arr = that.sortName(res, 'Name')
      console.log("arr",arr);

      let newArr = [];
      arr.forEach((item, i) => {
        let index = -1;
        let isExists = newArr.some((newItem, j) => {
          if (item.ESurName == newItem.ESurName) {
            index = j;
            return true;
          }
        })
        if (!isExists) {
          newArr.push({
            id:i,
            ESurName: item.ESurName,
            brands: [item]
          })
        } else {
          newArr[index].brands.push(item);
        }
      })
      newArr.forEach(item=>{
        item.ESurName = item.ESurName.toUpperCase();
      })
        that.setData({
          listMain: newArr
        });

    }).catch(err => {})
  },
  sortName(arr, eachName){
    arr.forEach(function (item) {
      let temp = item[eachName];
      item.sortName = temp;
    });
    let resultArray = arr.sort(
      function compareFunction(param1, param2) {
        return param1.sortName.localeCompare(param2.sortName, "zh");
      }
    );
    return resultArray;
  },
  onLoad: function(options) {
    var that = this;
    that.getData();
    console.log("options", options)
    if(options.type){
      this.setData({
        choosetype: options.type
      })
    }
    if (options.TCID) {
      let msg=this.data.msg;
      msg.TCID = options.TCID;
      this.setData({
        msg: msg
      })
    }
  }
})