
//index.js
//获取应用实例
const app = getApp()
var util = require('../../utils/util.js')

Page({
  data: {
    motto: 'Hello World',
    userInfo: {},
    hasUserInfo: false,
    canIUse: wx.canIUse('button.open-type.getUserInfo'),
    indicatorDots: true,
    vertical: false,
    autoplay: false,
    interval: 2000,
    duration: 500,
    loginState:true,
    dataInfo:{},
    todayMsg:{
      ConfigId:0,
      TCID:'',
      Date: '2019-11-03',
      GuestId:0,
      
    },
    todayList:[],
    contactState: true,
    contactInfo:{},
    airState:true,
    configId:'',
    tcid:'',
    pathUrl:'/pages/index/index',
    optionTCID:'7003',
    // 8705
    getimg:true,
    guidegrey:5,
    guidemsg:{
      LeaderId:0,
      Type:0,
      CreateBy:'',
      Score:0,
      Description:'',
    },

  },
 
  //事件处理函数
  bindViewTap: function() {
    // wx.navigateTo({
    //   url: '../logs/logs'
    // })
  },
  onLoad: function (options) {
    // if (app.globalData.userInfo) {
    //   this.setData({
    //     userInfo: app.globalData.userInfo,
    //     hasUserInfo: true
    //   })
    // } else if (this.data.canIUse){
    //   // 由于 getUserInfo 是网络请求，可能会在 Page.onLoad 之后才返回
    //   // 所以此处加入 callback 以防止这种情况
    //   app.userInfoReadyCallback = res => {
    //     this.setData({
    //       userInfo: res.userInfo,
    //       hasUserInfo: true
    //     })
    //   }
    // } else {
    //   // 在没有 open-type=getUserInfo 版本的兼容处理
    //   wx.getUserInfo({
    //     success: res => {
    //       app.globalData.userInfo = res.userInfo
    //       this.setData({
    //         userInfo: res.userInfo,
    //         hasUserInfo: true
    //       })
    //     }
    //   })
    // }
    console.log("options", options)
    let that=this;
    let openId = (wx.getStorageSync('openId'))
    if (!openId) {
      wx.login({
        success(res) {
          if (res.code) {
            //发起网络请求
            let msg={
              code: res.code,
              type: 2
            }
            app.$api('miniProgram_customer_HelpByLoginByOpenId', msg).then(res => {
              
              wx.setStorageSync('openId', res)
              that.setData({
                openId: res
              })
              that.login(res);
            }).catch(err => { })
          } else {
          }
        }
      })
    }
  },
  goVoucher(){
    wx.navigateTo({
      url: '/pages/VoucherDetails/VoucherDetails'
    })
  },
  goMsg(){
    wx.switchTab({ url: '/pages/msg/index/index' })

  },
  scoreColor(e) {
    let index = e.currentTarget.dataset.index;
    let guidemsg = this.data.guidemsg;
    guidemsg.Score = index;
    let guidegrey = 5 - guidemsg.Score;
    this.setData({
      guidemsg: guidemsg,
      guidegrey: guidegrey
    })
  },
  scoreGrey(e) {
    let index = e.currentTarget.dataset.index;
    let guidemsg = this.data.guidemsg;
    guidemsg.Score = index + guidemsg.Score;
    let guidegrey = 5 - guidemsg.Score;
    this.setData({
      guidemsg: guidemsg,
      guidegrey: guidegrey
    })
  },
  bindinputText(e) {
    let val = e.detail.value;
    let guidemsg = this.data.guidemsg;
    guidemsg.Description = val;
    this.setData({
      guidemsg: guidemsg
    })
  },
  setGuide() {
    let userInfo = (wx.getStorageSync('userInfo'))
    if (!userInfo) {
      util.showToast('text', '请先核对身份！', { duration: 3000 })
      return;
    }
    this.data.guidemsg.CreateBy = userInfo.GuestId;
    app.$api('b2b_set_SetLeaderGuideScore', this.data.guidemsg).then(res => {
      this.setData({
        contactState:true
      })

    }).catch(err => { })
  },
  dYBtn(){
    let userInfo = (wx.getStorageSync('userInfo'))
    let openId = (wx.getStorageSync('openId'))
    let msg={
      OpenId: openId,
      TempleteIdList:[],
      GuestId: userInfo.GuestId,
    };
    msg.TempleteIdList= ['h0wT8WWk0N2bMQTD8lDm3xC_8ns0MiH1QGYkL7oNNx8'];
    wx.requestSubscribeMessage({
      tmplIds: ['h0wT8WWk0N2bMQTD8lDm3xC_8ns0MiH1QGYkL7oNNx8'],
      success(res) {
        if (res.errMsg == "requestSubscribeMessage:ok" && res.h0wT8WWk0N2bMQTD8lDm3xC_8ns0MiH1QGYkL7oNNx8 == "accept"){
          app.$api('b2b_set_SetLXYGuestSubscribe', msg).then(res => {
            

          }).catch(err => { })
        }
      },
      fail(res) {
        
      },
    })
  },
  onShow: function (){
    let that = this;
    let userInfo = (wx.getStorageSync('userInfo'))
    if (userInfo) {
      that.setData({
        userInfo: userInfo,
        loginState: false
      })
    }
    that.getData();
  },
  goComment(e){
    let that = this;
    let userInfo = (wx.getStorageSync('userInfo'))
    let info = e.currentTarget.dataset.item;
    let Id = info.Id;
    let GuestId = userInfo.GuestId;
    wx.navigateTo({
      url: '/pages/comments/comments?GuestId=' + GuestId + '&Id=' + Id + '&Type=' + info.Type
    })
  },
  DakaBtn(e) {
    let that = this;
    let userInfo = (wx.getStorageSync('userInfo'))
    if (!userInfo) {
      util.showToast('text', '请先核对身份！', { duration: 3000 })
      return;
    }
    let info = e.currentTarget.dataset.item;
    let Id = info.Id;
    let GuestId = userInfo.GuestId;
    wx.navigateTo({
      url: '/pages/Clockin/Clockin?CreateBy=' + GuestId + '&SourceId=' + Id + '&Type=' + info.Type + '&Name=' + info.Name + '&index=true'
    })
    wx.setStorageSync('pathUrl', this.data.pathUrl)

  },
  goDetail(e){
    let that = this;
    let userInfo = (wx.getStorageSync('userInfo'))
    if (!userInfo){
      util.showToast('text', '请先核对身份！', { duration: 3000 })
      return;
    }
    let info = e.currentTarget.dataset.item;
    let Id = info.Id;
    let GuestId = userInfo.GuestId;
    let src="";
    if (info.Type==4){
      src ='/pages/index/hotelDetails/hotelDetails';
      wx.navigateTo({
        url: src+'?GuestId=' + GuestId + '&Id=' + Id
      })
    }
    if (info.Type==2) {
      src = '/pages/index/sceneDetail/sceneDetail';
      wx.navigateTo({
        url: src + '?GuestId=' + GuestId + '&Id=' + Id
      })
    }
    if (info.Type == 3) {
      src = '/pages/index/mealDetail/mealDetail';
      wx.navigateTo({
        url: src + '?GuestId=' + GuestId + '&Id=' + Id
      })
    }
    if (info.Type == 1) {
      src = '/pages/index/strateDateil/strateDateil';
      wx.navigateTo({
        url: src + '?GuestId=' + GuestId + '&Id=' + Id
      })
    }
    
  },
  tripDay(e){
    let that=this;
    let info = e.currentTarget.dataset.item;
    wx.navigateTo({
      url: '/pages/index/tripDay/tripDay?ConfigId=' + that.data.configId + "&TCID=" + that.data.tcid + "&DayNum=" + info.DayNum
    })
  },
  makePhone(e){
    let userInfo = (wx.getStorageSync('userInfo'))
    if (!userInfo) {
      util.showToast('text', '请先核对身份！', { duration: 3000 })
      return;
    }
    let phone = e.currentTarget.dataset.item.MobilePhone;
    wx.makePhoneCall({
      phoneNumber: phone,
    })
  },
  seeFight(){
    this.setData({
      airState: false,
    })
  },
  closeAir(e) {
    this.setData({
      airState: true,
    })
  },
  closeState(e){
    this.setData({
      contactState:true,
    })
  },
  noThing(e){
  },
  goWeb(e){
    let info = e.currentTarget.dataset.item;
    let name = info.Name;
    wx.navigateTo({
      url: '/pages/webview/webview?name='+name
    })
  },
  getContact(e){
    let guidemsg = this.data.guidemsg;
    guidemsg={
      LeaderId: 0,
      Type: 0,
      CreateBy: '',
      Score: 0,
      Description: '',
    }
    this.setData({
      guidemsg: guidemsg,
      guidegrey:5,
    })
    let info = e.currentTarget.dataset.item;
    
    let type = e.currentTarget.dataset.type;
    let contactInfo = this.data.contactInfo;
    contactInfo.type = type;
    console.log("info", info)
    console.log("type", type)
    contactInfo.LeaderId=info.Id;

    
    guidemsg.LeaderId = info.Id;
    guidemsg.Type = type;
    if(type==1){
      contactInfo.Name = info.Surname + info.Name;
      contactInfo.MobilePhone = info.MobilePhone;
      contactInfo.LdNum = info.LdNum;
      contactInfo.LdPhoto = info.LdPhoto;
      contactInfo.Score = parseInt(info.MyScore.Score);
      contactInfo.geryScore = 5 - contactInfo.Score;
      contactInfo.CommentState = info.IsLdComment;
      contactInfo.Description = info.MyScore.Description;
    }
    if (type == 2) {
      contactInfo.Name = info.Surname + info.Name;
      contactInfo.MobilePhone = info.MobilePhone;
      contactInfo.DyNum = info.DyNum;
      contactInfo.LdPhoto = info.DyPhoto;
      contactInfo.Score = parseInt(info.DyScore);
      contactInfo.geryScore = 5 - contactInfo.Score;
      contactInfo.CommentState = info.IsDyComment;
      contactInfo.Description = info.MyScore.Description;
    }
    if (type == 3) {
      contactInfo.Name = info.Contact;
      contactInfo.MobilePhone = info.ContactNumber;
      contactInfo.DyNum =info.CustomerNum;
      contactInfo.LdPhoto = info.CustomerPhoto;
      contactInfo.Score = parseInt(info.CustomerScore);
      contactInfo.geryScore = 5 - contactInfo.Score;
      contactInfo.CommentState = info.IsCustomerComment;
      contactInfo.Description = info.MyScore.Description;
    }
    this.setData({
      contactState:false,
      contactInfo: contactInfo,
      guidemsg: guidemsg,
    })

  },
  
  getData(){
    let userInfo = this.data.userInfo;
    let msg={
      ConfigId:0,
      TCID:this.data.optionTCID,
      OrderId: userInfo.OrderId ? userInfo.OrderId:'',
      CityId: userInfo.DepartureCityId ? userInfo.DepartureCityId:''
    };
    app.$api('b2b_get_GetMXYTravelIndexInfo', msg).then(res => {
      wx.setStorageSync('tcid', res.tcid)
      if (res.IsTravelEnd){
        // wx.navigateTo({
        //   url: '/pages/tripover/tripover'
        // })
      }
      if (res.CityList.length>0){
        res.CityList.forEach(item=>{
          item.all = parseInt(item.Score);
          item.grey = 5- parseInt(item.Score);
        })
      }
      let todayMsg = this.data.todayMsg;
      todayMsg.ConfigId = res.configId;
      todayMsg.TCID = res.tcid;
      
      this.setData({
        dataInfo:res,
        todayMsg: todayMsg,
        configId: res.configId,
        tcid: res.tcid
      })
      console.log("res", res)
      let chartOtherList=[];
      if (res.LeaderModel){
        let obj={};
        obj.name = res.LeaderModel.Surname + res.LeaderModel.Name;
        obj.LdPhoto = res.LeaderModel.LdPhoto;
        obj.Id = res.LeaderModel.Id;
        obj.LdIMAccount = res.LeaderModel.LdIMAccount;
        obj.MobilePhone = res.LeaderModel.MobilePhone;
        obj.typename = "领队";
        chartOtherList.push(obj);
      }
      if (res.GuideModel) {
        let obj = {};
        obj.name = res.GuideModel.Surname + res.GuideModel.Name;
        obj.LdPhoto = res.GuideModel.DyPhoto;
        obj.Id = res.GuideModel.Id;
        obj.LdIMAccount = res.GuideModel.DyIMAccount;
        obj.MobilePhone = res.GuideModel.MobilePhone;
        obj.typename = "导游";
        chartOtherList.push(obj);
      }
      if (res.CustomerModel) {
        let obj = {};
        obj.name = res.CustomerModel.Contact;
        obj.LdPhoto = res.CustomerModel.CustomerPhoto;
        obj.Id = res.CustomerModel.Id;
        obj.LdIMAccount = res.CustomerModel.CustomerIMAccount;
        obj.MobilePhone = res.CustomerModel.ContactNumber;
        obj.typename = "销售顾问";
        chartOtherList.push(obj);
      }
      wx.setStorageSync('chartOtherList', chartOtherList)
      this.getToday();
    }).catch(err => { })
  },
  getToday(){
    let todayMsg = this.data.todayMsg;
    let userInfo = (wx.getStorageSync('userInfo'))
    if (userInfo){
      todayMsg.GuestId = userInfo.GuestId;
      this.setData({
        todayMsg: todayMsg,
      })
    }
    
    app.$api('b2b_get_GetMXYToDayTourList', todayMsg).then(res => {
     
      if (res.Status==1){
        res.List.forEach(item=>{
          item.all = parseInt(item.Score);
          item.grey = 5 - parseInt(item.Score);
        })
        this.setData({
          todayList: res.List
        })
      }
      
    }).catch(err => { })
  },
  goCard(){
    let self = wx.getStorageSync('self')
    if(!self){
      this.setData({
        getimg:false
      })
    }
    else{
      wx.navigateTo({
        url: `/pages/validateForm/validate/validate?TCID${this.data.tcid}`
      })
    }
    
  },
  getUserInfo: function(e) {
    let self = e.detail.userInfo;
    wx.setStorageSync('self', self)
    this.setData({
      getimg: true
    })
    wx.navigateTo({
      url: `/pages/validateForm/validate/validate?TCID${this.data.tcid}`
    })
  }
})
