import request from '../utils/request.js'

/**
 * 获取试卷列表
 * @param {JSON参数} data 
 */
export function getPaperList(data) {
    return request({
        //url: '/AppletIndex/GetGuestExaminationPublishPage_V2', 
        url: '/AppletIndex/GetGuestPublishPage_V2',
        method: 'post',
        data
    })
}

/**
 * 获取试卷详情
 * @param {JSON参数} data 
 */
export function getPaperDetail(data) {
    return request({
        url: '/appletindex/GetPaperDetails',
        method: 'post',
        data
    })
}

/**
 * 提交试卷
 * @param {JSON参数} data 
 */
export function submitPaper(data) {
    return request({
        url: '/AppletIndex/StuSubmitExamPaper',
        method: 'post',
        data
    })
}

/**
 * 记录考试时间
 * @param {JSON参数} data 
 */
export function SetStuExamStartTime(data) {
    return request({
        url: '/AppletIndex/SetStuExamStartTime',
        method: 'post',
        data
    })
}

/**
 * 查询考试数据
 * @param {JSON参数} data 
 */
export function queryQuestionPageList(data) {
    return request({
        url: '/Question/GetQuestionPageList',
        method: 'post',
        data
    })
}

/**
 * 获取阅读理解
 * @param {JSON参数} data 
 */
export function GetQuestionReading(data) {
    return request({
        url: '/Exam/GetQuestionReading',
        method: 'post',
        data
    })
}

/**
 * 获取等级评测
 * @param {JSON参数} data 
 */
export function GetBankTypeList(data) {
    return request({
        url: '/Question/GetBankTypeList',
        method: 'post',
        data
    })
}

/**
 * 获取问题数量
 * @param {JSON参数} data 
 */
export function GetAppQuestionStatic(data) {
    return request({
        url: '/Exam/GetAppQuestionStatic',
        method: 'post',
        data
    })
}

/**
 * 获取单词
 * @param {JSON参数} data 
 */
export function GetQuestionWords(data) {
    return request({
        url: '/Exam/GetQuestionWords',
        method: 'post',
        data
    })
}

/**
 * 点击答案提交答题
 * @param {JSON参数} data 
 */
export function SetStudentPractice(data) {
    return request({
        url: '/Exam/SetStudentPractice',
        method: 'post',
        data
    })
}