//获取设备信息
export let getSystemInfo = (callback) => {
    uni.getSystemInfo({
        success: (res) => {
            callback(res)
        }
    })
}

//脱敏
export let desensitization = (str, beginLen, endLen) => {
    let len = str.length;
    let firstStr = str.substr(0, beginLen);
    let lastStr = str.substr(endLen);
    let middleStr = str.substring(beginLen, len - Math.abs(endLen)).replace(/[\s\S]/ig, '*');
    let tempStr = firstStr + middleStr + lastStr;
    return tempStr;
}

export let upload = (file, successCallback) => {
    let { UploadConfig } = uni.getStorageSync('userInfo')
    for (let i = 0; i < file.length; i++) {
        urlTobase64(file[i].url, (base64Str) => {
            console.log(23, base64Str)
            uni.uploadFile({
                url: UploadConfig.UploadDomain + "/UploadBase64",
                filePath: base64Str,
                name: 'myfile',
                success(res) {
                    successCallback(res.data)
                },
                fail(err) {
                    console.log("uploadErr", err)
                }
            });

        })
    }

}

// let strTobase64 = (str) => {
//     var buf = new ArrayBuffer(str.length * 2);
//     var bufView = new Uint16Array(buf);
//     for (var i = 0, strlen = str.length; i < strlen; i++) {
//         bufView[i] = str.charCodeAt(i);
//     }
//     var base64 = uni.arrayBufferToBase64(buf);
//     base64 = 'data:image/jpeg;base64,' + base64;
//     return base64;
// }
let urlTobase64 = (file, suc) => {
    uni.getFileSystemManager().readFile({
        filePath: file, //选择图片返回的相对路径
        encoding: 'base64', //编码格式
        success: (res) => { //成功的回调
            let data = res.data;
            let base64 = 'data:image/png;base64,' + data
            suc(base64);
        }
    });
}