//请求电商接口
let host = ''
if (process.env.NODE_ENV === "development") {
	host = 'http://192.168.10.65:8088/api'
} else {
	host = "https://mallapi.oytour.com/api"
}
import Toast from '../wxcomponents/vant/toast/toast';
let request = (param) => {
	//网络请求
	return new Promise((resolve, reject) => {
		let JHdata = uni.getStorageSync("userInfo");
		uni.request({
			url: host + param.url,
			method: param.method || "Post",
			header: param.header || {
				'content-type': "application/json",
				'token': JHdata.Token || ""
			},
			data: {
				msg: param.data,
				MallBaseId: parseInt(JHdata.JHMallBaseId),
				UserId: JHdata.JHMallUserId,
				TenantId: parseInt(JHdata.JHTenantId),
				EduStudentId: JHdata.Id,
				OpenId: JHdata.JHMallUserOpenId,
				SmallShopsId: 0,
				MiniAppId: "wx38e054ee42b054f4",
				token: JHdata.MallToken
			},
			success: res => {

				if (res.data.resultCode === 1) {
					resolve(res.data)
				} else {
					Toast({
						type: 'fail',
						message: res.data.message,
						onClose: () => {
							// if (res.data.resultCode === 10001 || res.data.resultCode === 10000 || res.data.resultCode === 10002 || res.data.resultCode === 10003) {
							// 	uni.reLaunch({
							// 		url: '/pages/login/login'
							// 	});
							// } else {
							// 	if (res.data.message.indexOf('用户凭证为空') != -1 || res.data.message.indexOf('用户凭证失效') != -1) {
							// 		uni.reLaunch({
							// 			url: '/pages/login/login'
							// 		});
							// 	}
							// }
						},
					});
				}
			},
			fail: (err) => {
				console.warn("fail:" + JSON.stringify(err));
				uni.showToast({
					title: '网络请求失败',
					duration: 2000,
					icon: "error",
				});
			}
		});
	})
}
export default request
