import request from '../utils/request.js'

/**
 * 账号密码登录
 * @param {JSON参数} data 
 */
export function login(data) {
    return request({
        url: '/AppletLogin/Login',
        method: 'post',
        data
    })
}

/**
 * 获取首页信息
 * @param {JSON参数} data 
 */
export function getIndexInfo(data) {
    return request({
        url: '/AppletIndex/GetIndexInfo',
        method: 'post',
        data
    })
}

/**
 * 获取课表信息
 * @param {JSON参数} data 
 */
export function getStundentPlanStatistical(data) {
    return request({
        url: '/AppletIndex/GetStundentPlanStatistical',
        method: 'post',
        data
    })
}

/**
 * 获取我的课程
 * @param {JSON参数} data 
 */
export function getCourse(data) {
    return request({
        url: '/AppletIndex/GetChapterTree',
        method: 'post',
        data
    })
}

/**
 * 获取我的电子合同
 * @param {JSON参数} data 
 */
export function getContract(data) {
    return request({
        url: '/AppletIndex/GetContractList',
        method: 'post',
        data
    })
}

/**
 * 获取我的课程进度
 * @param {JSON参数} data 
 */
export function getProgress(data) {
    return request({
        url: '/AppletIndex/GetStundentScheduleList',
        method: 'post',
        data
    })
}

/**
 * 获取剩余时间
 * @param {JSON参数} data 
 */
export function getStundentSurplus(data) {
    return request({
        url: '/AppletIndex/GetStundentSurplus',
        method: 'post',
        data
    })
}

/**
 * 学生请假申请
 * @param {JSON参数} data 
 */
export function setStudentLeave(data) {
    return request({
        url: '/LeaveStudent/SetStudentLeave',
        method: 'post',
        data
    })
}

/**
 * 学生请假列表
 * @param {JSON参数} data 
 */
export function getStudentLeaveList(data) {
    return request({
        url: '/AppletIndex/GetEducationReceiptPage',
        method: 'post',
        data
    })
}
/**
 * 申请作废
 * @param {JSON参数} data
 */
export function invalidReceiptInfo(data) {
    return request({
        url: '/AppletIndex/InvalidReceipt',
        method: 'post',
        data
    })
}
/**
 * 申请详情
 * @param {JSON参数} data
 */
export function getEduReceiptInfo(data) {
    return request({
        url: "/AppletIndex/GetEduReceiptInfo",
        method: 'post',
        data
    })
}

/**
 * 学习园地列表
 * @param {JSON参数} data
 */
export function getLearningGardenList(data) {
    return request({
        url: "/AppletIndex/GeLearningGardenPage",
        method: 'post',
        data
    })
}

/**
 * 学习园地详情
 * @param {JSON参数} data
 */
export function getLearningGardenDetail(data) {
    return request({
        url: "/AppletIndex/GetLearningGarden",
        method: 'post',
        data
    })
}