import request from '../utils/request.js'

/**
 * 获取试卷列表
 * @param {JSON参数} data 
 */
export function getPaperList(data) {
    return request({
        //url: '/AppletIndex/GetGuestExaminationPublishPage_V2', 
        url: '/AppletIndex/GetGuestPublishPage_V2',
        method: 'post',
        data
    })
}

/**
 * 获取试卷详情
 * @param {JSON参数} data 
 */
export function getPaperDetail(data) {
    return request({
        url: '/appletindex/GetPaperDetails',
        method: 'post',
        data
    })
}

/**
 * 提交试卷
 * @param {JSON参数} data 
 */
export function submitPaper(data) {
    return request({
        url: '/AppletIndex/StuSubmitExamPaper',
        method: 'post',
        data
    })
}

/**
 * 记录考试时间
 * @param {JSON参数} data 
 */
export function SetStuExamStartTime(data) {
    return request({
        url: '/AppletIndex/SetStuExamStartTime',
        method: 'post',
        data
    })
}