let host = 'http://192.168.20.17:8017/api'
if (process.env.NODE_ENV === "development") {
	host = 'http://192.168.20.17:8017/api'
	// host = 'http://192.168.20.24:8300/api'
} else {
	host = 'https://eduapi.oytour.com/api'
}
import Toast from '../wxcomponents/vant/toast/toast';
let request = (param) => {
	//网络请求
	return new Promise((resolve, reject) => {
		let token = uni.getStorageSync('userInfo').Token;
		uni.request({
			url: host + param.url,
			method: param.method || "Post",
			header: param.header || {
				'content-type': "application/json",
				'token': token || ""
			},
			data: {
				msg: param.data,
			},
			success: res => {
				if (res.data.Code === 1) {
					resolve(res.data)
				} else {
					Toast({
						type: 'fail',
						message: res.data.Message,
						onClose: () => {
							if (res.data.Code === 10001) {
								uni.navigateTo({
									url: '/pages/login/login'
								});
							}
						},
					});
				}
			},
			fail: (err) => {
				console.warn("fail:" + JSON.stringify(err));
				uni.showToast({
					title: '网络请求失败',
					duration: 2000,
					icon: "error",
				});
			}
		});
	})
}
export default request
