import { StaticConfig } from '@/config/app'
import { useMeta } from 'quasar'
import { reactive,ref } from 'vue'
interface LoginParams {
    Name: string,
    pageIndex: number,
    pageSize: number,
    rowsPerPage: number,
    pageCount: number,
  }
  interface addParams {
    Id: number, Name: string, Sort: number
  } 
const groupingManageModule = () => {
    const msg: LoginParams = reactive({
        Name: '',
        pageIndex: 1,
        pageSize: 15,
        rowsPerPage:15,
        pageCount:1
      })
    const addMsg: addParams = reactive({
        Id: 0, Name: '', Sort: 1
    })  
  const title = ref(StaticConfig.appsuffix)
  useMeta(() => {
    return {
      title: title.value
    }
  })
  //输入框的事件
  const resetSearch = () => {
    console.log(msg.Name)
  }
  



  const setTitle = (pageTitle: string, suffix = true) => {
    if (suffix) {
      title.value = `${pageTitle}-${StaticConfig.appsuffix}`
    } else {
      title.value = pageTitle
    }
  }
 

  return { setTitle,msg,addMsg ,resetSearch}
}

export default groupingManageModule
