// import { ResultType } from '@/@types/enumHelper'
// import router from '@/router'
import UserActions from '@/store/modules/user/actions'//{ UserActionsType }

// import { UserGetter } from '@/store/modules/user/getters'
// import { dispatchAction, getStoreGetter, setStoreState } from '@/store/utils'
import message from '@/utils/message'
import { reactive, ref } from 'vue'
interface LoginParams {
  username: string
  password: string
  remeber: boolean
}

const userUserLoginModule = () => {
  const userModel: LoginParams = reactive({
    username: '',
    password: '',
    remeber: false
  })

  const userValidateRule = reactive({
    usernameRule: [(val: any) => !!val || '请填写账户信息'],
    userpasswordRule: [(val: any) => !!val || '请填写密码信息']
  })
  const stateManager = reactive({
    subLogin: ref(false)
  })
  const usernameRef = ref(null)
  const passwordRef = ref(null)

  const loginSubmit = async () => {
    if (!stateManager.subLogin) {
      stateManager.subLogin = true
      const ur = usernameRef as any //断言任意类型
      const pr = passwordRef as any
      ur.value.validate()
      pr.value.validate()
      if (ur.value.hasError || pr.value.hasError) {
        message.warnMsg('请完善登录信息')
        stateManager.subLogin = false
      } else {
        const param = {
          Account: userModel.username,
          Password: userModel.password
        }

        // dispatchAction<UserActionsType>('user', 'userLogin', param)
          UserActions.userLogin(param)
        
          stateManager.subLogin = false
        
      }
    }
  }

  return { userModel, usernameRef, passwordRef, userValidateRule, loginSubmit, stateManager }
}

export default userUserLoginModule
