import { RouteRecordRaw } from 'vue-router'

const routes: RouteRecordRaw[] = [
	{
		path: '/index',
		component: () => import('@/layouts/MainLayout.vue'),
		children: [{ path: '', component: () => import('@/pages/Index.vue') }]
	},
	{
		path: '/groupingManage',
		component: () => import('@/layouts/MainLayout.vue'),
		children: [{ path: '', component: () => import('@/pages/drainage/groupingManage.vue') }]
	},
	{//客户管理  客户设置
		path: '/customerSetup',
		component: () => import('@/layouts/MainLayout.vue'),
		children: [{ path: '', component: () => import('@/pages/customer/customerSetup.vue') }]
	},
	
	{
		path:'/auth/login',
		component: () => import('@/pages/auth/login.vue')
	},
	{
		path:'/auth/regist',
		component: () => import('@/pages/auth/regist.vue')
	},
	
	// Always leave this as last one,
	// but you can also remove it
	{
		path: '/:catchAll(.*)*',
		component: () => import('pages/Error404.vue')
	}
]

export default routes
