import { getStoreGetter } from '@/store/utils'
import { UserGetter } from '@/store/modules/user/getters'
import { ResultType } from '@/@types/enumHelper'

/**
 * @description 获取授权信息
 */
export function getAuth() {
  const token = getStoreGetter<UserGetter>('user', 'getUserToken')
  return token != ResultType.Empty
}

/**
 * 获取用户所有的权限菜单
 * @returns 菜单数组
 */
export function getUserAllMenu() {
  const auths = getStoreGetter<UserGetter>('user', 'getUserAllAuth')
  console.log(auths)
  return auths.length > 0 ? auths : ResultType.EmptyArray
}
